# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PredictionUri(object):
    """
    Prediction URI per use-case.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PredictionUri object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param use_case:
            The value to assign to the use_case property of this PredictionUri.
        :type use_case: str

        :param uri:
            The value to assign to the uri property of this PredictionUri.
        :type uri: str

        """
        self.swagger_types = {
            'use_case': 'str',
            'uri': 'str'
        }
        self.attribute_map = {
            'use_case': 'useCase',
            'uri': 'uri'
        }
        self._use_case = None
        self._uri = None

    @property
    def use_case(self):
        """
        **[Required]** Gets the use_case of this PredictionUri.
        Prediction use-case.


        :return: The use_case of this PredictionUri.
        :rtype: str
        """
        return self._use_case

    @use_case.setter
    def use_case(self, use_case):
        """
        Sets the use_case of this PredictionUri.
        Prediction use-case.


        :param use_case: The use_case of this PredictionUri.
        :type: str
        """
        self._use_case = use_case

    @property
    def uri(self):
        """
        **[Required]** Gets the uri of this PredictionUri.
        Prediction URI.


        :return: The uri of this PredictionUri.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this PredictionUri.
        Prediction URI.


        :param uri: The uri of this PredictionUri.
        :type: str
        """
        self._uri = uri

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
