# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutonomousDatabaseInBackup(object):
    """
    Details of Autonomous AI Database in Autonomous Container Database
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AutonomousDatabaseInBackup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this AutonomousDatabaseInBackup.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this AutonomousDatabaseInBackup.
        :type display_name: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName'
        }
        self._compartment_id = None
        self._display_name = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AutonomousDatabaseInBackup.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AutonomousDatabaseInBackup.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AutonomousDatabaseInBackup.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AutonomousDatabaseInBackup.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AutonomousDatabaseInBackup.
        The user-friendly name for the Autonomous AI Database. The name does not have to be unique.


        :return: The display_name of this AutonomousDatabaseInBackup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AutonomousDatabaseInBackup.
        The user-friendly name for the Autonomous AI Database. The name does not have to be unique.


        :param display_name: The display_name of this AutonomousDatabaseInBackup.
        :type: str
        """
        self._display_name = display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
