# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupDestinationProperties(object):
    """
    The properties of the backup destination associated with the Autonomous Container Database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BackupDestinationProperties object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backup_destination_attach_history:
            The value to assign to the backup_destination_attach_history property of this BackupDestinationProperties.
        :type backup_destination_attach_history: list[datetime]

        :param space_utilized_in_gbs:
            The value to assign to the space_utilized_in_gbs property of this BackupDestinationProperties.
        :type space_utilized_in_gbs: int

        :param time_at_which_storage_details_are_updated:
            The value to assign to the time_at_which_storage_details_are_updated property of this BackupDestinationProperties.
        :type time_at_which_storage_details_are_updated: datetime

        """
        self.swagger_types = {
            'backup_destination_attach_history': 'list[datetime]',
            'space_utilized_in_gbs': 'int',
            'time_at_which_storage_details_are_updated': 'datetime'
        }
        self.attribute_map = {
            'backup_destination_attach_history': 'backupDestinationAttachHistory',
            'space_utilized_in_gbs': 'spaceUtilizedInGBs',
            'time_at_which_storage_details_are_updated': 'timeAtWhichStorageDetailsAreUpdated'
        }
        self._backup_destination_attach_history = None
        self._space_utilized_in_gbs = None
        self._time_at_which_storage_details_are_updated = None

    @property
    def backup_destination_attach_history(self):
        """
        Gets the backup_destination_attach_history of this BackupDestinationProperties.
        The timestamps at which this backup destination is used as the preferred destination to host the Autonomous Container Database backups.


        :return: The backup_destination_attach_history of this BackupDestinationProperties.
        :rtype: list[datetime]
        """
        return self._backup_destination_attach_history

    @backup_destination_attach_history.setter
    def backup_destination_attach_history(self, backup_destination_attach_history):
        """
        Sets the backup_destination_attach_history of this BackupDestinationProperties.
        The timestamps at which this backup destination is used as the preferred destination to host the Autonomous Container Database backups.


        :param backup_destination_attach_history: The backup_destination_attach_history of this BackupDestinationProperties.
        :type: list[datetime]
        """
        self._backup_destination_attach_history = backup_destination_attach_history

    @property
    def space_utilized_in_gbs(self):
        """
        Gets the space_utilized_in_gbs of this BackupDestinationProperties.
        The total space utilized (in GBs) by this Autonomous Container Database on this backup destination, rounded to the nearest integer.


        :return: The space_utilized_in_gbs of this BackupDestinationProperties.
        :rtype: int
        """
        return self._space_utilized_in_gbs

    @space_utilized_in_gbs.setter
    def space_utilized_in_gbs(self, space_utilized_in_gbs):
        """
        Sets the space_utilized_in_gbs of this BackupDestinationProperties.
        The total space utilized (in GBs) by this Autonomous Container Database on this backup destination, rounded to the nearest integer.


        :param space_utilized_in_gbs: The space_utilized_in_gbs of this BackupDestinationProperties.
        :type: int
        """
        self._space_utilized_in_gbs = space_utilized_in_gbs

    @property
    def time_at_which_storage_details_are_updated(self):
        """
        Gets the time_at_which_storage_details_are_updated of this BackupDestinationProperties.
        The latest timestamp when the backup destination details, such as 'spaceUtilized,' are updated.


        :return: The time_at_which_storage_details_are_updated of this BackupDestinationProperties.
        :rtype: datetime
        """
        return self._time_at_which_storage_details_are_updated

    @time_at_which_storage_details_are_updated.setter
    def time_at_which_storage_details_are_updated(self, time_at_which_storage_details_are_updated):
        """
        Sets the time_at_which_storage_details_are_updated of this BackupDestinationProperties.
        The latest timestamp when the backup destination details, such as 'spaceUtilized,' are updated.


        :param time_at_which_storage_details_are_updated: The time_at_which_storage_details_are_updated of this BackupDestinationProperties.
        :type: datetime
        """
        self._time_at_which_storage_details_are_updated = time_at_which_storage_details_are_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
