# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigureExascaleExadataInfrastructureDetails(object):
    """
    The exascale config request details for the Exadata Cloud@Customer infrastructure.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigureExascaleExadataInfrastructureDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_storage_in_gbs:
            The value to assign to the total_storage_in_gbs property of this ConfigureExascaleExadataInfrastructureDetails.
        :type total_storage_in_gbs: int

        :param total_vm_storage_in_gbs:
            The value to assign to the total_vm_storage_in_gbs property of this ConfigureExascaleExadataInfrastructureDetails.
        :type total_vm_storage_in_gbs: int

        """
        self.swagger_types = {
            'total_storage_in_gbs': 'int',
            'total_vm_storage_in_gbs': 'int'
        }
        self.attribute_map = {
            'total_storage_in_gbs': 'totalStorageInGBs',
            'total_vm_storage_in_gbs': 'totalVmStorageInGBs'
        }
        self._total_storage_in_gbs = None
        self._total_vm_storage_in_gbs = None

    @property
    def total_storage_in_gbs(self):
        """
        **[Required]** Gets the total_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        Storage size needed for Exascale in GBs.


        :return: The total_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        :rtype: int
        """
        return self._total_storage_in_gbs

    @total_storage_in_gbs.setter
    def total_storage_in_gbs(self, total_storage_in_gbs):
        """
        Sets the total_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        Storage size needed for Exascale in GBs.


        :param total_storage_in_gbs: The total_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        :type: int
        """
        self._total_storage_in_gbs = total_storage_in_gbs

    @property
    def total_vm_storage_in_gbs(self):
        """
        Gets the total_vm_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        Storage size needed for VM storage on Exascale in GBs.


        :return: The total_vm_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        :rtype: int
        """
        return self._total_vm_storage_in_gbs

    @total_vm_storage_in_gbs.setter
    def total_vm_storage_in_gbs(self, total_vm_storage_in_gbs):
        """
        Sets the total_vm_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        Storage size needed for VM storage on Exascale in GBs.


        :param total_vm_storage_in_gbs: The total_vm_storage_in_gbs of this ConfigureExascaleExadataInfrastructureDetails.
        :type: int
        """
        self._total_vm_storage_in_gbs = total_vm_storage_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
