# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDbConnectionBundleDetails(object):
    """
    The details for creating a database connection bundle.
    """

    #: A constant which can be used with the db_connection_bundle_type property of a CreateDbConnectionBundleDetails.
    #: This constant has a value of "TLS"
    DB_CONNECTION_BUNDLE_TYPE_TLS = "TLS"

    #: A constant which can be used with the db_connection_bundle_type property of a CreateDbConnectionBundleDetails.
    #: This constant has a value of "MTLS"
    DB_CONNECTION_BUNDLE_TYPE_MTLS = "MTLS"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDbConnectionBundleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDbConnectionBundleDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateDbConnectionBundleDetails.
        :type display_name: str

        :param db_connection_bundle_type:
            The value to assign to the db_connection_bundle_type property of this CreateDbConnectionBundleDetails.
            Allowed values for this property are: "TLS", "MTLS"
        :type db_connection_bundle_type: str

        :param associated_resource_details:
            The value to assign to the associated_resource_details property of this CreateDbConnectionBundleDetails.
        :type associated_resource_details: list[oci.database.models.AssociatedResourceDetails]

        :param tenant_id:
            The value to assign to the tenant_id property of this CreateDbConnectionBundleDetails.
        :type tenant_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDbConnectionBundleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDbConnectionBundleDetails.
        :type defined_tags: dict(str, dict(str, str))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'db_connection_bundle_type': 'str',
            'associated_resource_details': 'list[AssociatedResourceDetails]',
            'tenant_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, str))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'db_connection_bundle_type': 'dbConnectionBundleType',
            'associated_resource_details': 'associatedResourceDetails',
            'tenant_id': 'tenantId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._db_connection_bundle_type = None
        self._associated_resource_details = None
        self._tenant_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDbConnectionBundleDetails.
        The OCID of the compartment where you want to create the database connection bundle.


        :return: The compartment_id of this CreateDbConnectionBundleDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDbConnectionBundleDetails.
        The OCID of the compartment where you want to create the database connection bundle.


        :param compartment_id: The compartment_id of this CreateDbConnectionBundleDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateDbConnectionBundleDetails.
        Display name for the connection bundle.


        :return: The display_name of this CreateDbConnectionBundleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDbConnectionBundleDetails.
        Display name for the connection bundle.


        :param display_name: The display_name of this CreateDbConnectionBundleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def db_connection_bundle_type(self):
        """
        **[Required]** Gets the db_connection_bundle_type of this CreateDbConnectionBundleDetails.
        The type of the database connection bundle.

        Allowed values for this property are: "TLS", "MTLS"


        :return: The db_connection_bundle_type of this CreateDbConnectionBundleDetails.
        :rtype: str
        """
        return self._db_connection_bundle_type

    @db_connection_bundle_type.setter
    def db_connection_bundle_type(self, db_connection_bundle_type):
        """
        Sets the db_connection_bundle_type of this CreateDbConnectionBundleDetails.
        The type of the database connection bundle.


        :param db_connection_bundle_type: The db_connection_bundle_type of this CreateDbConnectionBundleDetails.
        :type: str
        """
        allowed_values = ["TLS", "MTLS"]
        if not value_allowed_none_or_none_sentinel(db_connection_bundle_type, allowed_values):
            raise ValueError(
                f"Invalid value for `db_connection_bundle_type`, must be None or one of {allowed_values}"
            )
        self._db_connection_bundle_type = db_connection_bundle_type

    @property
    def associated_resource_details(self):
        """
        **[Required]** Gets the associated_resource_details of this CreateDbConnectionBundleDetails.
        Details about the resources to associate with the connection bundle.


        :return: The associated_resource_details of this CreateDbConnectionBundleDetails.
        :rtype: list[oci.database.models.AssociatedResourceDetails]
        """
        return self._associated_resource_details

    @associated_resource_details.setter
    def associated_resource_details(self, associated_resource_details):
        """
        Sets the associated_resource_details of this CreateDbConnectionBundleDetails.
        Details about the resources to associate with the connection bundle.


        :param associated_resource_details: The associated_resource_details of this CreateDbConnectionBundleDetails.
        :type: list[oci.database.models.AssociatedResourceDetails]
        """
        self._associated_resource_details = associated_resource_details

    @property
    def tenant_id(self):
        """
        Gets the tenant_id of this CreateDbConnectionBundleDetails.
        The tenancy ID for the connection bundle.


        :return: The tenant_id of this CreateDbConnectionBundleDetails.
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """
        Sets the tenant_id of this CreateDbConnectionBundleDetails.
        The tenancy ID for the connection bundle.


        :param tenant_id: The tenant_id of this CreateDbConnectionBundleDetails.
        :type: str
        """
        self._tenant_id = tenant_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDbConnectionBundleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDbConnectionBundleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDbConnectionBundleDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDbConnectionBundleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDbConnectionBundleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDbConnectionBundleDetails.
        :rtype: dict(str, dict(str, str))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDbConnectionBundleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDbConnectionBundleDetails.
        :type: dict(str, dict(str, str))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
