# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbnodeSnapshotSummary(object):
    """
    Details of the Exadata Database Node Snapshot.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbnodeSnapshotSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DbnodeSnapshotSummary.
        :type id: str

        :param source_dbnode_id:
            The value to assign to the source_dbnode_id property of this DbnodeSnapshotSummary.
        :type source_dbnode_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DbnodeSnapshotSummary.
        :type lifecycle_state: str

        :param name:
            The value to assign to the name property of this DbnodeSnapshotSummary.
        :type name: str

        :param time_created:
            The value to assign to the time_created property of this DbnodeSnapshotSummary.
        :type time_created: datetime

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DbnodeSnapshotSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DbnodeSnapshotSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DbnodeSnapshotSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DbnodeSnapshotSummary.
        :type system_tags: dict(str, dict(str, object))

        :param compartment_id:
            The value to assign to the compartment_id property of this DbnodeSnapshotSummary.
        :type compartment_id: str

        :param cluster_id:
            The value to assign to the cluster_id property of this DbnodeSnapshotSummary.
        :type cluster_id: str

        :param mount_points:
            The value to assign to the mount_points property of this DbnodeSnapshotSummary.
        :type mount_points: list[oci.database.models.MountPointDetails]

        :param volumes:
            The value to assign to the volumes property of this DbnodeSnapshotSummary.
        :type volumes: list[oci.database.models.VolumeDetails]

        """
        self.swagger_types = {
            'id': 'str',
            'source_dbnode_id': 'str',
            'lifecycle_state': 'str',
            'name': 'str',
            'time_created': 'datetime',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'compartment_id': 'str',
            'cluster_id': 'str',
            'mount_points': 'list[MountPointDetails]',
            'volumes': 'list[VolumeDetails]'
        }
        self.attribute_map = {
            'id': 'id',
            'source_dbnode_id': 'sourceDbnodeId',
            'lifecycle_state': 'lifecycleState',
            'name': 'name',
            'time_created': 'timeCreated',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'compartment_id': 'compartmentId',
            'cluster_id': 'clusterId',
            'mount_points': 'mountPoints',
            'volumes': 'volumes'
        }
        self._id = None
        self._source_dbnode_id = None
        self._lifecycle_state = None
        self._name = None
        self._time_created = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._compartment_id = None
        self._cluster_id = None
        self._mount_points = None
        self._volumes = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbnodeSnapshotSummary.
        The `OCID`__ of the Exadata Database Node Snapshot.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DbnodeSnapshotSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbnodeSnapshotSummary.
        The `OCID`__ of the Exadata Database Node Snapshot.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DbnodeSnapshotSummary.
        :type: str
        """
        self._id = id

    @property
    def source_dbnode_id(self):
        """
        **[Required]** Gets the source_dbnode_id of this DbnodeSnapshotSummary.
        The `OCID`__ of the Exadata Database Node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The source_dbnode_id of this DbnodeSnapshotSummary.
        :rtype: str
        """
        return self._source_dbnode_id

    @source_dbnode_id.setter
    def source_dbnode_id(self, source_dbnode_id):
        """
        Sets the source_dbnode_id of this DbnodeSnapshotSummary.
        The `OCID`__ of the Exadata Database Node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param source_dbnode_id: The source_dbnode_id of this DbnodeSnapshotSummary.
        :type: str
        """
        self._source_dbnode_id = source_dbnode_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this DbnodeSnapshotSummary.
        The current state of the Exadata Database Storage Vault.


        :return: The lifecycle_state of this DbnodeSnapshotSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DbnodeSnapshotSummary.
        The current state of the Exadata Database Storage Vault.


        :param lifecycle_state: The lifecycle_state of this DbnodeSnapshotSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DbnodeSnapshotSummary.
        The user-friendly name for the Database Node Snapshot. The name should be unique.


        :return: The name of this DbnodeSnapshotSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DbnodeSnapshotSummary.
        The user-friendly name for the Database Node Snapshot. The name should be unique.


        :param name: The name of this DbnodeSnapshotSummary.
        :type: str
        """
        self._name = name

    @property
    def time_created(self):
        """
        Gets the time_created of this DbnodeSnapshotSummary.
        The date and time that the Exadata Database Node Snapshot was created.


        :return: The time_created of this DbnodeSnapshotSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbnodeSnapshotSummary.
        The date and time that the Exadata Database Node Snapshot was created.


        :param time_created: The time_created of this DbnodeSnapshotSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DbnodeSnapshotSummary.
        Additional information about the current lifecycle state of the Exadata Database Node Snapshot.


        :return: The lifecycle_details of this DbnodeSnapshotSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DbnodeSnapshotSummary.
        Additional information about the current lifecycle state of the Exadata Database Node Snapshot.


        :param lifecycle_details: The lifecycle_details of this DbnodeSnapshotSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DbnodeSnapshotSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DbnodeSnapshotSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DbnodeSnapshotSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DbnodeSnapshotSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DbnodeSnapshotSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DbnodeSnapshotSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DbnodeSnapshotSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DbnodeSnapshotSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DbnodeSnapshotSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this DbnodeSnapshotSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DbnodeSnapshotSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this DbnodeSnapshotSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this DbnodeSnapshotSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DbnodeSnapshotSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DbnodeSnapshotSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DbnodeSnapshotSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def cluster_id(self):
        """
        Gets the cluster_id of this DbnodeSnapshotSummary.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cluster_id of this DbnodeSnapshotSummary.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this DbnodeSnapshotSummary.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cluster_id: The cluster_id of this DbnodeSnapshotSummary.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def mount_points(self):
        """
        Gets the mount_points of this DbnodeSnapshotSummary.
        Details of the mount points


        :return: The mount_points of this DbnodeSnapshotSummary.
        :rtype: list[oci.database.models.MountPointDetails]
        """
        return self._mount_points

    @mount_points.setter
    def mount_points(self, mount_points):
        """
        Sets the mount_points of this DbnodeSnapshotSummary.
        Details of the mount points


        :param mount_points: The mount_points of this DbnodeSnapshotSummary.
        :type: list[oci.database.models.MountPointDetails]
        """
        self._mount_points = mount_points

    @property
    def volumes(self):
        """
        Gets the volumes of this DbnodeSnapshotSummary.
        Details of the volumes


        :return: The volumes of this DbnodeSnapshotSummary.
        :rtype: list[oci.database.models.VolumeDetails]
        """
        return self._volumes

    @volumes.setter
    def volumes(self, volumes):
        """
        Sets the volumes of this DbnodeSnapshotSummary.
        Details of the volumes


        :param volumes: The volumes of this DbnodeSnapshotSummary.
        :type: list[oci.database.models.VolumeDetails]
        """
        self._volumes = volumes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
