# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadbVmCluster(object):
    """
    Details of the Exadata VM cluster on Exascale Infrastructure. Applies to Exadata Database Service on Exascale Infrastructure only.
    """

    #: A constant which can be used with the lifecycle_state property of a ExadbVmCluster.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a ExadbVmCluster.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a ExadbVmCluster.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ExadbVmCluster.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a ExadbVmCluster.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the lifecycle_state property of a ExadbVmCluster.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a ExadbVmCluster.
    #: This constant has a value of "MAINTENANCE_IN_PROGRESS"
    LIFECYCLE_STATE_MAINTENANCE_IN_PROGRESS = "MAINTENANCE_IN_PROGRESS"

    #: A constant which can be used with the grid_image_type property of a ExadbVmCluster.
    #: This constant has a value of "RELEASE_UPDATE"
    GRID_IMAGE_TYPE_RELEASE_UPDATE = "RELEASE_UPDATE"

    #: A constant which can be used with the grid_image_type property of a ExadbVmCluster.
    #: This constant has a value of "CUSTOM_IMAGE"
    GRID_IMAGE_TYPE_CUSTOM_IMAGE = "CUSTOM_IMAGE"

    #: A constant which can be used with the license_model property of a ExadbVmCluster.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a ExadbVmCluster.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    #: A constant which can be used with the shape_attribute property of a ExadbVmCluster.
    #: This constant has a value of "SMART_STORAGE"
    SHAPE_ATTRIBUTE_SMART_STORAGE = "SMART_STORAGE"

    #: A constant which can be used with the shape_attribute property of a ExadbVmCluster.
    #: This constant has a value of "BLOCK_STORAGE"
    SHAPE_ATTRIBUTE_BLOCK_STORAGE = "BLOCK_STORAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new ExadbVmCluster object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param iorm_config_cache:
            The value to assign to the iorm_config_cache property of this ExadbVmCluster.
        :type iorm_config_cache: oci.database.models.ExadataIormConfig

        :param id:
            The value to assign to the id property of this ExadbVmCluster.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ExadbVmCluster.
        :type compartment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this ExadbVmCluster.
        :type availability_domain: str

        :param subnet_id:
            The value to assign to the subnet_id property of this ExadbVmCluster.
        :type subnet_id: str

        :param backup_subnet_id:
            The value to assign to the backup_subnet_id property of this ExadbVmCluster.
        :type backup_subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this ExadbVmCluster.
        :type nsg_ids: list[str]

        :param backup_network_nsg_ids:
            The value to assign to the backup_network_nsg_ids property of this ExadbVmCluster.
        :type backup_network_nsg_ids: list[str]

        :param last_update_history_entry_id:
            The value to assign to the last_update_history_entry_id property of this ExadbVmCluster.
        :type last_update_history_entry_id: str

        :param listener_port:
            The value to assign to the listener_port property of this ExadbVmCluster.
        :type listener_port: int

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ExadbVmCluster.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param node_count:
            The value to assign to the node_count property of this ExadbVmCluster.
        :type node_count: int

        :param shape:
            The value to assign to the shape property of this ExadbVmCluster.
        :type shape: str

        :param display_name:
            The value to assign to the display_name property of this ExadbVmCluster.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this ExadbVmCluster.
        :type time_created: datetime

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ExadbVmCluster.
        :type lifecycle_details: str

        :param time_zone:
            The value to assign to the time_zone property of this ExadbVmCluster.
        :type time_zone: str

        :param hostname:
            The value to assign to the hostname property of this ExadbVmCluster.
        :type hostname: str

        :param domain:
            The value to assign to the domain property of this ExadbVmCluster.
        :type domain: str

        :param cluster_name:
            The value to assign to the cluster_name property of this ExadbVmCluster.
        :type cluster_name: str

        :param gi_version:
            The value to assign to the gi_version property of this ExadbVmCluster.
        :type gi_version: str

        :param grid_image_id:
            The value to assign to the grid_image_id property of this ExadbVmCluster.
        :type grid_image_id: str

        :param grid_image_type:
            The value to assign to the grid_image_type property of this ExadbVmCluster.
            Allowed values for this property are: "RELEASE_UPDATE", "CUSTOM_IMAGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type grid_image_type: str

        :param system_version:
            The value to assign to the system_version property of this ExadbVmCluster.
        :type system_version: str

        :param ssh_public_keys:
            The value to assign to the ssh_public_keys property of this ExadbVmCluster.
        :type ssh_public_keys: list[str]

        :param license_model:
            The value to assign to the license_model property of this ExadbVmCluster.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type license_model: str

        :param scan_ip_ids:
            The value to assign to the scan_ip_ids property of this ExadbVmCluster.
        :type scan_ip_ids: list[str]

        :param vip_ids:
            The value to assign to the vip_ids property of this ExadbVmCluster.
        :type vip_ids: list[str]

        :param scan_dns_record_id:
            The value to assign to the scan_dns_record_id property of this ExadbVmCluster.
        :type scan_dns_record_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ExadbVmCluster.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ExadbVmCluster.
        :type defined_tags: dict(str, dict(str, object))

        :param security_attributes:
            The value to assign to the security_attributes property of this ExadbVmCluster.
        :type security_attributes: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ExadbVmCluster.
        :type system_tags: dict(str, dict(str, object))

        :param scan_dns_name:
            The value to assign to the scan_dns_name property of this ExadbVmCluster.
        :type scan_dns_name: str

        :param zone_id:
            The value to assign to the zone_id property of this ExadbVmCluster.
        :type zone_id: str

        :param scan_listener_port_tcp:
            The value to assign to the scan_listener_port_tcp property of this ExadbVmCluster.
        :type scan_listener_port_tcp: int

        :param scan_listener_port_tcp_ssl:
            The value to assign to the scan_listener_port_tcp_ssl property of this ExadbVmCluster.
        :type scan_listener_port_tcp_ssl: int

        :param private_zone_id:
            The value to assign to the private_zone_id property of this ExadbVmCluster.
        :type private_zone_id: str

        :param data_collection_options:
            The value to assign to the data_collection_options property of this ExadbVmCluster.
        :type data_collection_options: oci.database.models.DataCollectionOptions

        :param total_e_cpu_count:
            The value to assign to the total_e_cpu_count property of this ExadbVmCluster.
        :type total_e_cpu_count: int

        :param enabled_e_cpu_count:
            The value to assign to the enabled_e_cpu_count property of this ExadbVmCluster.
        :type enabled_e_cpu_count: int

        :param vm_file_system_storage:
            The value to assign to the vm_file_system_storage property of this ExadbVmCluster.
        :type vm_file_system_storage: oci.database.models.ExadbVmClusterStorageDetails

        :param snapshot_file_system_storage:
            The value to assign to the snapshot_file_system_storage property of this ExadbVmCluster.
        :type snapshot_file_system_storage: oci.database.models.ExadbVmClusterStorageDetails

        :param total_file_system_storage:
            The value to assign to the total_file_system_storage property of this ExadbVmCluster.
        :type total_file_system_storage: oci.database.models.ExadbVmClusterStorageDetails

        :param exascale_db_storage_vault_id:
            The value to assign to the exascale_db_storage_vault_id property of this ExadbVmCluster.
        :type exascale_db_storage_vault_id: str

        :param memory_size_in_gbs:
            The value to assign to the memory_size_in_gbs property of this ExadbVmCluster.
        :type memory_size_in_gbs: int

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this ExadbVmCluster.
        :type cluster_placement_group_id: str

        :param subscription_id:
            The value to assign to the subscription_id property of this ExadbVmCluster.
        :type subscription_id: str

        :param shape_attribute:
            The value to assign to the shape_attribute property of this ExadbVmCluster.
            Allowed values for this property are: "SMART_STORAGE", "BLOCK_STORAGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type shape_attribute: str

        """
        self.swagger_types = {
            'iorm_config_cache': 'ExadataIormConfig',
            'id': 'str',
            'compartment_id': 'str',
            'availability_domain': 'str',
            'subnet_id': 'str',
            'backup_subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'backup_network_nsg_ids': 'list[str]',
            'last_update_history_entry_id': 'str',
            'listener_port': 'int',
            'lifecycle_state': 'str',
            'node_count': 'int',
            'shape': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'lifecycle_details': 'str',
            'time_zone': 'str',
            'hostname': 'str',
            'domain': 'str',
            'cluster_name': 'str',
            'gi_version': 'str',
            'grid_image_id': 'str',
            'grid_image_type': 'str',
            'system_version': 'str',
            'ssh_public_keys': 'list[str]',
            'license_model': 'str',
            'scan_ip_ids': 'list[str]',
            'vip_ids': 'list[str]',
            'scan_dns_record_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'security_attributes': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'scan_dns_name': 'str',
            'zone_id': 'str',
            'scan_listener_port_tcp': 'int',
            'scan_listener_port_tcp_ssl': 'int',
            'private_zone_id': 'str',
            'data_collection_options': 'DataCollectionOptions',
            'total_e_cpu_count': 'int',
            'enabled_e_cpu_count': 'int',
            'vm_file_system_storage': 'ExadbVmClusterStorageDetails',
            'snapshot_file_system_storage': 'ExadbVmClusterStorageDetails',
            'total_file_system_storage': 'ExadbVmClusterStorageDetails',
            'exascale_db_storage_vault_id': 'str',
            'memory_size_in_gbs': 'int',
            'cluster_placement_group_id': 'str',
            'subscription_id': 'str',
            'shape_attribute': 'str'
        }
        self.attribute_map = {
            'iorm_config_cache': 'iormConfigCache',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'availability_domain': 'availabilityDomain',
            'subnet_id': 'subnetId',
            'backup_subnet_id': 'backupSubnetId',
            'nsg_ids': 'nsgIds',
            'backup_network_nsg_ids': 'backupNetworkNsgIds',
            'last_update_history_entry_id': 'lastUpdateHistoryEntryId',
            'listener_port': 'listenerPort',
            'lifecycle_state': 'lifecycleState',
            'node_count': 'nodeCount',
            'shape': 'shape',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'lifecycle_details': 'lifecycleDetails',
            'time_zone': 'timeZone',
            'hostname': 'hostname',
            'domain': 'domain',
            'cluster_name': 'clusterName',
            'gi_version': 'giVersion',
            'grid_image_id': 'gridImageId',
            'grid_image_type': 'gridImageType',
            'system_version': 'systemVersion',
            'ssh_public_keys': 'sshPublicKeys',
            'license_model': 'licenseModel',
            'scan_ip_ids': 'scanIpIds',
            'vip_ids': 'vipIds',
            'scan_dns_record_id': 'scanDnsRecordId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'security_attributes': 'securityAttributes',
            'system_tags': 'systemTags',
            'scan_dns_name': 'scanDnsName',
            'zone_id': 'zoneId',
            'scan_listener_port_tcp': 'scanListenerPortTcp',
            'scan_listener_port_tcp_ssl': 'scanListenerPortTcpSsl',
            'private_zone_id': 'privateZoneId',
            'data_collection_options': 'dataCollectionOptions',
            'total_e_cpu_count': 'totalECpuCount',
            'enabled_e_cpu_count': 'enabledECpuCount',
            'vm_file_system_storage': 'vmFileSystemStorage',
            'snapshot_file_system_storage': 'snapshotFileSystemStorage',
            'total_file_system_storage': 'totalFileSystemStorage',
            'exascale_db_storage_vault_id': 'exascaleDbStorageVaultId',
            'memory_size_in_gbs': 'memorySizeInGBs',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'subscription_id': 'subscriptionId',
            'shape_attribute': 'shapeAttribute'
        }
        self._iorm_config_cache = None
        self._id = None
        self._compartment_id = None
        self._availability_domain = None
        self._subnet_id = None
        self._backup_subnet_id = None
        self._nsg_ids = None
        self._backup_network_nsg_ids = None
        self._last_update_history_entry_id = None
        self._listener_port = None
        self._lifecycle_state = None
        self._node_count = None
        self._shape = None
        self._display_name = None
        self._time_created = None
        self._lifecycle_details = None
        self._time_zone = None
        self._hostname = None
        self._domain = None
        self._cluster_name = None
        self._gi_version = None
        self._grid_image_id = None
        self._grid_image_type = None
        self._system_version = None
        self._ssh_public_keys = None
        self._license_model = None
        self._scan_ip_ids = None
        self._vip_ids = None
        self._scan_dns_record_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._security_attributes = None
        self._system_tags = None
        self._scan_dns_name = None
        self._zone_id = None
        self._scan_listener_port_tcp = None
        self._scan_listener_port_tcp_ssl = None
        self._private_zone_id = None
        self._data_collection_options = None
        self._total_e_cpu_count = None
        self._enabled_e_cpu_count = None
        self._vm_file_system_storage = None
        self._snapshot_file_system_storage = None
        self._total_file_system_storage = None
        self._exascale_db_storage_vault_id = None
        self._memory_size_in_gbs = None
        self._cluster_placement_group_id = None
        self._subscription_id = None
        self._shape_attribute = None

    @property
    def iorm_config_cache(self):
        """
        Gets the iorm_config_cache of this ExadbVmCluster.

        :return: The iorm_config_cache of this ExadbVmCluster.
        :rtype: oci.database.models.ExadataIormConfig
        """
        return self._iorm_config_cache

    @iorm_config_cache.setter
    def iorm_config_cache(self, iorm_config_cache):
        """
        Sets the iorm_config_cache of this ExadbVmCluster.

        :param iorm_config_cache: The iorm_config_cache of this ExadbVmCluster.
        :type: oci.database.models.ExadataIormConfig
        """
        self._iorm_config_cache = iorm_config_cache

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ExadbVmCluster.
        The `OCID`__ of the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this ExadbVmCluster.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExadbVmCluster.
        The `OCID`__ of the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this ExadbVmCluster.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ExadbVmCluster.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ExadbVmCluster.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ExadbVmCluster.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this ExadbVmCluster.
        The name of the availability domain in which the Exadata VM cluster on Exascale Infrastructure is located.


        :return: The availability_domain of this ExadbVmCluster.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this ExadbVmCluster.
        The name of the availability domain in which the Exadata VM cluster on Exascale Infrastructure is located.


        :param availability_domain: The availability_domain of this ExadbVmCluster.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this ExadbVmCluster.
        The `OCID`__ of the subnet associated with the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this ExadbVmCluster.
        The `OCID`__ of the subnet associated with the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this ExadbVmCluster.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def backup_subnet_id(self):
        """
        **[Required]** Gets the backup_subnet_id of this ExadbVmCluster.
        The `OCID`__ of the backup network subnet associated with the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The backup_subnet_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._backup_subnet_id

    @backup_subnet_id.setter
    def backup_subnet_id(self, backup_subnet_id):
        """
        Sets the backup_subnet_id of this ExadbVmCluster.
        The `OCID`__ of the backup network subnet associated with the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param backup_subnet_id: The backup_subnet_id of this ExadbVmCluster.
        :type: str
        """
        self._backup_subnet_id = backup_subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this ExadbVmCluster.
        The list of `OCIDs`__ for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see `Security Rules`__.
        **NsgIds restrictions:**
        - A network security group (NSG) is optional for Autonomous AI Databases with private access. The nsgIds list can be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The nsg_ids of this ExadbVmCluster.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this ExadbVmCluster.
        The list of `OCIDs`__ for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see `Security Rules`__.
        **NsgIds restrictions:**
        - A network security group (NSG) is optional for Autonomous AI Databases with private access. The nsgIds list can be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param nsg_ids: The nsg_ids of this ExadbVmCluster.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def backup_network_nsg_ids(self):
        """
        Gets the backup_network_nsg_ids of this ExadbVmCluster.
        A list of the `OCIDs`__ of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see `Security Rules`__. Applicable only to Exadata systems.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The backup_network_nsg_ids of this ExadbVmCluster.
        :rtype: list[str]
        """
        return self._backup_network_nsg_ids

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, backup_network_nsg_ids):
        """
        Sets the backup_network_nsg_ids of this ExadbVmCluster.
        A list of the `OCIDs`__ of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see `Security Rules`__. Applicable only to Exadata systems.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param backup_network_nsg_ids: The backup_network_nsg_ids of this ExadbVmCluster.
        :type: list[str]
        """
        self._backup_network_nsg_ids = backup_network_nsg_ids

    @property
    def last_update_history_entry_id(self):
        """
        Gets the last_update_history_entry_id of this ExadbVmCluster.
        The `OCID`__ of the last maintenance update history entry. This value is updated when a maintenance update starts.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The last_update_history_entry_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._last_update_history_entry_id

    @last_update_history_entry_id.setter
    def last_update_history_entry_id(self, last_update_history_entry_id):
        """
        Sets the last_update_history_entry_id of this ExadbVmCluster.
        The `OCID`__ of the last maintenance update history entry. This value is updated when a maintenance update starts.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param last_update_history_entry_id: The last_update_history_entry_id of this ExadbVmCluster.
        :type: str
        """
        self._last_update_history_entry_id = last_update_history_entry_id

    @property
    def listener_port(self):
        """
        Gets the listener_port of this ExadbVmCluster.
        The port number configured for the listener on the Exadata VM cluster on Exascale Infrastructure.


        :return: The listener_port of this ExadbVmCluster.
        :rtype: int
        """
        return self._listener_port

    @listener_port.setter
    def listener_port(self, listener_port):
        """
        Sets the listener_port of this ExadbVmCluster.
        The port number configured for the listener on the Exadata VM cluster on Exascale Infrastructure.


        :param listener_port: The listener_port of this ExadbVmCluster.
        :type: int
        """
        self._listener_port = listener_port

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ExadbVmCluster.
        The current state of the Exadata VM cluster on Exascale Infrastructure.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ExadbVmCluster.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ExadbVmCluster.
        The current state of the Exadata VM cluster on Exascale Infrastructure.


        :param lifecycle_state: The lifecycle_state of this ExadbVmCluster.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def node_count(self):
        """
        **[Required]** Gets the node_count of this ExadbVmCluster.
        The number of nodes in the Exadata VM cluster on Exascale Infrastructure.


        :return: The node_count of this ExadbVmCluster.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this ExadbVmCluster.
        The number of nodes in the Exadata VM cluster on Exascale Infrastructure.


        :param node_count: The node_count of this ExadbVmCluster.
        :type: int
        """
        self._node_count = node_count

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this ExadbVmCluster.
        The shape of the Exadata VM cluster on Exascale Infrastructure resource


        :return: The shape of this ExadbVmCluster.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ExadbVmCluster.
        The shape of the Exadata VM cluster on Exascale Infrastructure resource


        :param shape: The shape of this ExadbVmCluster.
        :type: str
        """
        self._shape = shape

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ExadbVmCluster.
        The user-friendly name for the Exadata VM cluster on Exascale Infrastructure. The name does not need to be unique.


        :return: The display_name of this ExadbVmCluster.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ExadbVmCluster.
        The user-friendly name for the Exadata VM cluster on Exascale Infrastructure. The name does not need to be unique.


        :param display_name: The display_name of this ExadbVmCluster.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        Gets the time_created of this ExadbVmCluster.
        The date and time that the Exadata VM cluster on Exascale Infrastructure was created.


        :return: The time_created of this ExadbVmCluster.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ExadbVmCluster.
        The date and time that the Exadata VM cluster on Exascale Infrastructure was created.


        :param time_created: The time_created of this ExadbVmCluster.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ExadbVmCluster.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this ExadbVmCluster.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ExadbVmCluster.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this ExadbVmCluster.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_zone(self):
        """
        Gets the time_zone of this ExadbVmCluster.
        The time zone to use for the Exadata VM cluster on Exascale Infrastructure. For details, see `Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :return: The time_zone of this ExadbVmCluster.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """
        Sets the time_zone of this ExadbVmCluster.
        The time zone to use for the Exadata VM cluster on Exascale Infrastructure. For details, see `Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :param time_zone: The time_zone of this ExadbVmCluster.
        :type: str
        """
        self._time_zone = time_zone

    @property
    def hostname(self):
        """
        **[Required]** Gets the hostname of this ExadbVmCluster.
        The hostname for the Exadata VM cluster on Exascale Infrastructure. The hostname must begin with an alphabetic character, and
        can contain alphanumeric characters and hyphens (-). For Exadata systems, the maximum length of the hostname is 12 characters.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique,
        then the Exadata VM cluster on Exascale Infrastructure will fail to provision.


        :return: The hostname of this ExadbVmCluster.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this ExadbVmCluster.
        The hostname for the Exadata VM cluster on Exascale Infrastructure. The hostname must begin with an alphabetic character, and
        can contain alphanumeric characters and hyphens (-). For Exadata systems, the maximum length of the hostname is 12 characters.

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet. If it is not unique,
        then the Exadata VM cluster on Exascale Infrastructure will fail to provision.


        :param hostname: The hostname of this ExadbVmCluster.
        :type: str
        """
        self._hostname = hostname

    @property
    def domain(self):
        """
        **[Required]** Gets the domain of this ExadbVmCluster.
        A domain name used for the Exadata VM cluster on Exascale Infrastructure. If the Oracle-provided internet and VCN
        resolver is enabled for the specified subnet, then the domain name for the subnet is used
        (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        Applies to Exadata Database Service on Exascale Infrastructure only.


        :return: The domain of this ExadbVmCluster.
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """
        Sets the domain of this ExadbVmCluster.
        A domain name used for the Exadata VM cluster on Exascale Infrastructure. If the Oracle-provided internet and VCN
        resolver is enabled for the specified subnet, then the domain name for the subnet is used
        (do not provide one). Otherwise, provide a valid DNS domain name. Hyphens (-) are not permitted.
        Applies to Exadata Database Service on Exascale Infrastructure only.


        :param domain: The domain of this ExadbVmCluster.
        :type: str
        """
        self._domain = domain

    @property
    def cluster_name(self):
        """
        Gets the cluster_name of this ExadbVmCluster.
        The cluster name for Exadata VM cluster on Exascale Infrastructure. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.


        :return: The cluster_name of this ExadbVmCluster.
        :rtype: str
        """
        return self._cluster_name

    @cluster_name.setter
    def cluster_name(self, cluster_name):
        """
        Sets the cluster_name of this ExadbVmCluster.
        The cluster name for Exadata VM cluster on Exascale Infrastructure. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.


        :param cluster_name: The cluster_name of this ExadbVmCluster.
        :type: str
        """
        self._cluster_name = cluster_name

    @property
    def gi_version(self):
        """
        Gets the gi_version of this ExadbVmCluster.
        A valid Oracle Grid Infrastructure (GI) software version.


        :return: The gi_version of this ExadbVmCluster.
        :rtype: str
        """
        return self._gi_version

    @gi_version.setter
    def gi_version(self, gi_version):
        """
        Sets the gi_version of this ExadbVmCluster.
        A valid Oracle Grid Infrastructure (GI) software version.


        :param gi_version: The gi_version of this ExadbVmCluster.
        :type: str
        """
        self._gi_version = gi_version

    @property
    def grid_image_id(self):
        """
        Gets the grid_image_id of this ExadbVmCluster.
        Grid Setup will be done using this grid image id.

        The grid image ID can be obtained using the API /20160918/giVersions/{majorVersion}/minorVersions?compartmentId=<compartmentId>&shapeFamily=EXADB_XS&availabilityDomain=<AD name>.
        The list of supported major versions can be obtained using the API /20160918/giVersions?compartmentId=<compartmentId>&shape=ExaDbXS&availabilityDomain=<AD name>


        :return: The grid_image_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._grid_image_id

    @grid_image_id.setter
    def grid_image_id(self, grid_image_id):
        """
        Sets the grid_image_id of this ExadbVmCluster.
        Grid Setup will be done using this grid image id.

        The grid image ID can be obtained using the API /20160918/giVersions/{majorVersion}/minorVersions?compartmentId=<compartmentId>&shapeFamily=EXADB_XS&availabilityDomain=<AD name>.
        The list of supported major versions can be obtained using the API /20160918/giVersions?compartmentId=<compartmentId>&shape=ExaDbXS&availabilityDomain=<AD name>


        :param grid_image_id: The grid_image_id of this ExadbVmCluster.
        :type: str
        """
        self._grid_image_id = grid_image_id

    @property
    def grid_image_type(self):
        """
        Gets the grid_image_type of this ExadbVmCluster.
        The type of Grid Image

        Allowed values for this property are: "RELEASE_UPDATE", "CUSTOM_IMAGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The grid_image_type of this ExadbVmCluster.
        :rtype: str
        """
        return self._grid_image_type

    @grid_image_type.setter
    def grid_image_type(self, grid_image_type):
        """
        Sets the grid_image_type of this ExadbVmCluster.
        The type of Grid Image


        :param grid_image_type: The grid_image_type of this ExadbVmCluster.
        :type: str
        """
        allowed_values = ["RELEASE_UPDATE", "CUSTOM_IMAGE"]
        if not value_allowed_none_or_none_sentinel(grid_image_type, allowed_values):
            grid_image_type = 'UNKNOWN_ENUM_VALUE'
        self._grid_image_type = grid_image_type

    @property
    def system_version(self):
        """
        Gets the system_version of this ExadbVmCluster.
        Operating system version of the image.


        :return: The system_version of this ExadbVmCluster.
        :rtype: str
        """
        return self._system_version

    @system_version.setter
    def system_version(self, system_version):
        """
        Sets the system_version of this ExadbVmCluster.
        Operating system version of the image.


        :param system_version: The system_version of this ExadbVmCluster.
        :type: str
        """
        self._system_version = system_version

    @property
    def ssh_public_keys(self):
        """
        **[Required]** Gets the ssh_public_keys of this ExadbVmCluster.
        The public key portion of one or more key pairs used for SSH access to the Exadata VM cluster on Exascale Infrastructure.


        :return: The ssh_public_keys of this ExadbVmCluster.
        :rtype: list[str]
        """
        return self._ssh_public_keys

    @ssh_public_keys.setter
    def ssh_public_keys(self, ssh_public_keys):
        """
        Sets the ssh_public_keys of this ExadbVmCluster.
        The public key portion of one or more key pairs used for SSH access to the Exadata VM cluster on Exascale Infrastructure.


        :param ssh_public_keys: The ssh_public_keys of this ExadbVmCluster.
        :type: list[str]
        """
        self._ssh_public_keys = ssh_public_keys

    @property
    def license_model(self):
        """
        Gets the license_model of this ExadbVmCluster.
        The Oracle license model that applies to the Exadata VM cluster on Exascale Infrastructure. The default is BRING_YOUR_OWN_LICENSE.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The license_model of this ExadbVmCluster.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this ExadbVmCluster.
        The Oracle license model that applies to the Exadata VM cluster on Exascale Infrastructure. The default is BRING_YOUR_OWN_LICENSE.


        :param license_model: The license_model of this ExadbVmCluster.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            license_model = 'UNKNOWN_ENUM_VALUE'
        self._license_model = license_model

    @property
    def scan_ip_ids(self):
        """
        Gets the scan_ip_ids of this ExadbVmCluster.
        The `OCID`__ of the Single Client Access Name (SCAN) IP addresses associated with the Exadata VM cluster on Exascale Infrastructure.
        SCAN IP addresses are typically used for load balancing and are not assigned to any interface.
        Oracle Clusterware directs the requests to the appropriate nodes in the cluster.

        **Note:** For a single-node DB system, this list is empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The scan_ip_ids of this ExadbVmCluster.
        :rtype: list[str]
        """
        return self._scan_ip_ids

    @scan_ip_ids.setter
    def scan_ip_ids(self, scan_ip_ids):
        """
        Sets the scan_ip_ids of this ExadbVmCluster.
        The `OCID`__ of the Single Client Access Name (SCAN) IP addresses associated with the Exadata VM cluster on Exascale Infrastructure.
        SCAN IP addresses are typically used for load balancing and are not assigned to any interface.
        Oracle Clusterware directs the requests to the appropriate nodes in the cluster.

        **Note:** For a single-node DB system, this list is empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param scan_ip_ids: The scan_ip_ids of this ExadbVmCluster.
        :type: list[str]
        """
        self._scan_ip_ids = scan_ip_ids

    @property
    def vip_ids(self):
        """
        Gets the vip_ids of this ExadbVmCluster.
        The `OCID`__ of the virtual IP (VIP) addresses associated with the Exadata VM cluster on Exascale Infrastructure.
        The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to
        enable failover. If one node fails, then the VIP is reassigned to another active node in the cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vip_ids of this ExadbVmCluster.
        :rtype: list[str]
        """
        return self._vip_ids

    @vip_ids.setter
    def vip_ids(self, vip_ids):
        """
        Sets the vip_ids of this ExadbVmCluster.
        The `OCID`__ of the virtual IP (VIP) addresses associated with the Exadata VM cluster on Exascale Infrastructure.
        The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to
        enable failover. If one node fails, then the VIP is reassigned to another active node in the cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vip_ids: The vip_ids of this ExadbVmCluster.
        :type: list[str]
        """
        self._vip_ids = vip_ids

    @property
    def scan_dns_record_id(self):
        """
        Gets the scan_dns_record_id of this ExadbVmCluster.
        The `OCID`__ of the DNS record for the SCAN IP addresses that are associated with the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The scan_dns_record_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._scan_dns_record_id

    @scan_dns_record_id.setter
    def scan_dns_record_id(self, scan_dns_record_id):
        """
        Sets the scan_dns_record_id of this ExadbVmCluster.
        The `OCID`__ of the DNS record for the SCAN IP addresses that are associated with the Exadata VM cluster on Exascale Infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param scan_dns_record_id: The scan_dns_record_id of this ExadbVmCluster.
        :type: str
        """
        self._scan_dns_record_id = scan_dns_record_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ExadbVmCluster.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ExadbVmCluster.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ExadbVmCluster.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ExadbVmCluster.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ExadbVmCluster.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ExadbVmCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ExadbVmCluster.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ExadbVmCluster.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this ExadbVmCluster.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The security_attributes of this ExadbVmCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this ExadbVmCluster.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param security_attributes: The security_attributes of this ExadbVmCluster.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ExadbVmCluster.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this ExadbVmCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ExadbVmCluster.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this ExadbVmCluster.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def scan_dns_name(self):
        """
        Gets the scan_dns_name of this ExadbVmCluster.
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the Exadata VM cluster on Exascale Infrastructure.


        :return: The scan_dns_name of this ExadbVmCluster.
        :rtype: str
        """
        return self._scan_dns_name

    @scan_dns_name.setter
    def scan_dns_name(self, scan_dns_name):
        """
        Sets the scan_dns_name of this ExadbVmCluster.
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the Exadata VM cluster on Exascale Infrastructure.


        :param scan_dns_name: The scan_dns_name of this ExadbVmCluster.
        :type: str
        """
        self._scan_dns_name = scan_dns_name

    @property
    def zone_id(self):
        """
        Gets the zone_id of this ExadbVmCluster.
        The OCID of the zone with which the Exadata VM cluster on Exascale Infrastructure is associated.


        :return: The zone_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._zone_id

    @zone_id.setter
    def zone_id(self, zone_id):
        """
        Sets the zone_id of this ExadbVmCluster.
        The OCID of the zone with which the Exadata VM cluster on Exascale Infrastructure is associated.


        :param zone_id: The zone_id of this ExadbVmCluster.
        :type: str
        """
        self._zone_id = zone_id

    @property
    def scan_listener_port_tcp(self):
        """
        Gets the scan_listener_port_tcp of this ExadbVmCluster.
        The TCP Single Client Access Name (SCAN) port. The default port is 1521.


        :return: The scan_listener_port_tcp of this ExadbVmCluster.
        :rtype: int
        """
        return self._scan_listener_port_tcp

    @scan_listener_port_tcp.setter
    def scan_listener_port_tcp(self, scan_listener_port_tcp):
        """
        Sets the scan_listener_port_tcp of this ExadbVmCluster.
        The TCP Single Client Access Name (SCAN) port. The default port is 1521.


        :param scan_listener_port_tcp: The scan_listener_port_tcp of this ExadbVmCluster.
        :type: int
        """
        self._scan_listener_port_tcp = scan_listener_port_tcp

    @property
    def scan_listener_port_tcp_ssl(self):
        """
        Gets the scan_listener_port_tcp_ssl of this ExadbVmCluster.
        The Secured Communication (TCPS) protocol Single Client Access Name (SCAN) port. The default port is 2484.


        :return: The scan_listener_port_tcp_ssl of this ExadbVmCluster.
        :rtype: int
        """
        return self._scan_listener_port_tcp_ssl

    @scan_listener_port_tcp_ssl.setter
    def scan_listener_port_tcp_ssl(self, scan_listener_port_tcp_ssl):
        """
        Sets the scan_listener_port_tcp_ssl of this ExadbVmCluster.
        The Secured Communication (TCPS) protocol Single Client Access Name (SCAN) port. The default port is 2484.


        :param scan_listener_port_tcp_ssl: The scan_listener_port_tcp_ssl of this ExadbVmCluster.
        :type: int
        """
        self._scan_listener_port_tcp_ssl = scan_listener_port_tcp_ssl

    @property
    def private_zone_id(self):
        """
        Gets the private_zone_id of this ExadbVmCluster.
        The private zone ID in which you want DNS records to be created.


        :return: The private_zone_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._private_zone_id

    @private_zone_id.setter
    def private_zone_id(self, private_zone_id):
        """
        Sets the private_zone_id of this ExadbVmCluster.
        The private zone ID in which you want DNS records to be created.


        :param private_zone_id: The private_zone_id of this ExadbVmCluster.
        :type: str
        """
        self._private_zone_id = private_zone_id

    @property
    def data_collection_options(self):
        """
        Gets the data_collection_options of this ExadbVmCluster.

        :return: The data_collection_options of this ExadbVmCluster.
        :rtype: oci.database.models.DataCollectionOptions
        """
        return self._data_collection_options

    @data_collection_options.setter
    def data_collection_options(self, data_collection_options):
        """
        Sets the data_collection_options of this ExadbVmCluster.

        :param data_collection_options: The data_collection_options of this ExadbVmCluster.
        :type: oci.database.models.DataCollectionOptions
        """
        self._data_collection_options = data_collection_options

    @property
    def total_e_cpu_count(self):
        """
        **[Required]** Gets the total_e_cpu_count of this ExadbVmCluster.
        The number of Total ECPUs for an Exadata VM cluster on Exascale Infrastructure.


        :return: The total_e_cpu_count of this ExadbVmCluster.
        :rtype: int
        """
        return self._total_e_cpu_count

    @total_e_cpu_count.setter
    def total_e_cpu_count(self, total_e_cpu_count):
        """
        Sets the total_e_cpu_count of this ExadbVmCluster.
        The number of Total ECPUs for an Exadata VM cluster on Exascale Infrastructure.


        :param total_e_cpu_count: The total_e_cpu_count of this ExadbVmCluster.
        :type: int
        """
        self._total_e_cpu_count = total_e_cpu_count

    @property
    def enabled_e_cpu_count(self):
        """
        **[Required]** Gets the enabled_e_cpu_count of this ExadbVmCluster.
        The number of ECPUs to enable for an Exadata VM cluster on Exascale Infrastructure.


        :return: The enabled_e_cpu_count of this ExadbVmCluster.
        :rtype: int
        """
        return self._enabled_e_cpu_count

    @enabled_e_cpu_count.setter
    def enabled_e_cpu_count(self, enabled_e_cpu_count):
        """
        Sets the enabled_e_cpu_count of this ExadbVmCluster.
        The number of ECPUs to enable for an Exadata VM cluster on Exascale Infrastructure.


        :param enabled_e_cpu_count: The enabled_e_cpu_count of this ExadbVmCluster.
        :type: int
        """
        self._enabled_e_cpu_count = enabled_e_cpu_count

    @property
    def vm_file_system_storage(self):
        """
        **[Required]** Gets the vm_file_system_storage of this ExadbVmCluster.

        :return: The vm_file_system_storage of this ExadbVmCluster.
        :rtype: oci.database.models.ExadbVmClusterStorageDetails
        """
        return self._vm_file_system_storage

    @vm_file_system_storage.setter
    def vm_file_system_storage(self, vm_file_system_storage):
        """
        Sets the vm_file_system_storage of this ExadbVmCluster.

        :param vm_file_system_storage: The vm_file_system_storage of this ExadbVmCluster.
        :type: oci.database.models.ExadbVmClusterStorageDetails
        """
        self._vm_file_system_storage = vm_file_system_storage

    @property
    def snapshot_file_system_storage(self):
        """
        Gets the snapshot_file_system_storage of this ExadbVmCluster.

        :return: The snapshot_file_system_storage of this ExadbVmCluster.
        :rtype: oci.database.models.ExadbVmClusterStorageDetails
        """
        return self._snapshot_file_system_storage

    @snapshot_file_system_storage.setter
    def snapshot_file_system_storage(self, snapshot_file_system_storage):
        """
        Sets the snapshot_file_system_storage of this ExadbVmCluster.

        :param snapshot_file_system_storage: The snapshot_file_system_storage of this ExadbVmCluster.
        :type: oci.database.models.ExadbVmClusterStorageDetails
        """
        self._snapshot_file_system_storage = snapshot_file_system_storage

    @property
    def total_file_system_storage(self):
        """
        Gets the total_file_system_storage of this ExadbVmCluster.

        :return: The total_file_system_storage of this ExadbVmCluster.
        :rtype: oci.database.models.ExadbVmClusterStorageDetails
        """
        return self._total_file_system_storage

    @total_file_system_storage.setter
    def total_file_system_storage(self, total_file_system_storage):
        """
        Sets the total_file_system_storage of this ExadbVmCluster.

        :param total_file_system_storage: The total_file_system_storage of this ExadbVmCluster.
        :type: oci.database.models.ExadbVmClusterStorageDetails
        """
        self._total_file_system_storage = total_file_system_storage

    @property
    def exascale_db_storage_vault_id(self):
        """
        **[Required]** Gets the exascale_db_storage_vault_id of this ExadbVmCluster.
        The `OCID`__ of the Exadata Database Storage Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The exascale_db_storage_vault_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._exascale_db_storage_vault_id

    @exascale_db_storage_vault_id.setter
    def exascale_db_storage_vault_id(self, exascale_db_storage_vault_id):
        """
        Sets the exascale_db_storage_vault_id of this ExadbVmCluster.
        The `OCID`__ of the Exadata Database Storage Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param exascale_db_storage_vault_id: The exascale_db_storage_vault_id of this ExadbVmCluster.
        :type: str
        """
        self._exascale_db_storage_vault_id = exascale_db_storage_vault_id

    @property
    def memory_size_in_gbs(self):
        """
        Gets the memory_size_in_gbs of this ExadbVmCluster.
        The memory that you want to be allocated in GBs. Memory is calculated based on 11 GB per VM core reserved.


        :return: The memory_size_in_gbs of this ExadbVmCluster.
        :rtype: int
        """
        return self._memory_size_in_gbs

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, memory_size_in_gbs):
        """
        Sets the memory_size_in_gbs of this ExadbVmCluster.
        The memory that you want to be allocated in GBs. Memory is calculated based on 11 GB per VM core reserved.


        :param memory_size_in_gbs: The memory_size_in_gbs of this ExadbVmCluster.
        :type: int
        """
        self._memory_size_in_gbs = memory_size_in_gbs

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this ExadbVmCluster.
        The `OCID`__ of the cluster placement group of the Exadata Infrastructure or Db System.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cluster_placement_group_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this ExadbVmCluster.
        The `OCID`__ of the cluster placement group of the Exadata Infrastructure or Db System.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cluster_placement_group_id: The cluster_placement_group_id of this ExadbVmCluster.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def subscription_id(self):
        """
        Gets the subscription_id of this ExadbVmCluster.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subscription_id of this ExadbVmCluster.
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """
        Sets the subscription_id of this ExadbVmCluster.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subscription_id: The subscription_id of this ExadbVmCluster.
        :type: str
        """
        self._subscription_id = subscription_id

    @property
    def shape_attribute(self):
        """
        Gets the shape_attribute of this ExadbVmCluster.
        The type of Exascale storage used for Exadata VM cluster. The default is SMART_STORAGE which supports Oracle Database 23ai and later

        Allowed values for this property are: "SMART_STORAGE", "BLOCK_STORAGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The shape_attribute of this ExadbVmCluster.
        :rtype: str
        """
        return self._shape_attribute

    @shape_attribute.setter
    def shape_attribute(self, shape_attribute):
        """
        Sets the shape_attribute of this ExadbVmCluster.
        The type of Exascale storage used for Exadata VM cluster. The default is SMART_STORAGE which supports Oracle Database 23ai and later


        :param shape_attribute: The shape_attribute of this ExadbVmCluster.
        :type: str
        """
        allowed_values = ["SMART_STORAGE", "BLOCK_STORAGE"]
        if not value_allowed_none_or_none_sentinel(shape_attribute, allowed_values):
            shape_attribute = 'UNKNOWN_ENUM_VALUE'
        self._shape_attribute = shape_attribute

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
