# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourcePoolShapeSummary(object):
    """
    An Autonomous AI Database Resource Pool. This object provides all the information related to the resource pool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourcePoolShapeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param shape:
            The value to assign to the shape property of this ResourcePoolShapeSummary.
        :type shape: int

        """
        self.swagger_types = {
            'shape': 'int'
        }
        self.attribute_map = {
            'shape': 'shape'
        }
        self._shape = None

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this ResourcePoolShapeSummary.
        Predefined shape of the resource pool.


        :return: The shape of this ResourcePoolShapeSummary.
        :rtype: int
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ResourcePoolShapeSummary.
        Predefined shape of the resource pool.


        :param shape: The shape of this ResourcePoolShapeSummary.
        :type: int
        """
        self._shape = shape

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
