# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChangeMysqlDatabaseManagementTypeDetails(object):
    """
    Details to change managed MySQL database management type.
    """

    #: A constant which can be used with the operation property of a ChangeMysqlDatabaseManagementTypeDetails.
    #: This constant has a value of "ENABLE_DBMGMT"
    OPERATION_ENABLE_DBMGMT = "ENABLE_DBMGMT"

    #: A constant which can be used with the operation property of a ChangeMysqlDatabaseManagementTypeDetails.
    #: This constant has a value of "UPDATE_DBMGMT_TYPE"
    OPERATION_UPDATE_DBMGMT_TYPE = "UPDATE_DBMGMT_TYPE"

    #: A constant which can be used with the operation property of a ChangeMysqlDatabaseManagementTypeDetails.
    #: This constant has a value of "DISABLE_DBMGMT"
    OPERATION_DISABLE_DBMGMT = "DISABLE_DBMGMT"

    def __init__(self, **kwargs):
        """
        Initializes a new ChangeMysqlDatabaseManagementTypeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param management_type:
            The value to assign to the management_type property of this ChangeMysqlDatabaseManagementTypeDetails.
        :type management_type: str

        :param operation:
            The value to assign to the operation property of this ChangeMysqlDatabaseManagementTypeDetails.
            Allowed values for this property are: "ENABLE_DBMGMT", "UPDATE_DBMGMT_TYPE", "DISABLE_DBMGMT"
        :type operation: str

        """
        self.swagger_types = {
            'management_type': 'str',
            'operation': 'str'
        }
        self.attribute_map = {
            'management_type': 'managementType',
            'operation': 'operation'
        }
        self._management_type = None
        self._operation = None

    @property
    def management_type(self):
        """
        **[Required]** Gets the management_type of this ChangeMysqlDatabaseManagementTypeDetails.
        The type of HeatWave management.


        :return: The management_type of this ChangeMysqlDatabaseManagementTypeDetails.
        :rtype: str
        """
        return self._management_type

    @management_type.setter
    def management_type(self, management_type):
        """
        Sets the management_type of this ChangeMysqlDatabaseManagementTypeDetails.
        The type of HeatWave management.


        :param management_type: The management_type of this ChangeMysqlDatabaseManagementTypeDetails.
        :type: str
        """
        self._management_type = management_type

    @property
    def operation(self):
        """
        Gets the operation of this ChangeMysqlDatabaseManagementTypeDetails.
        The type of operation to perform: update managementType, enable or disable database management.

        Allowed values for this property are: "ENABLE_DBMGMT", "UPDATE_DBMGMT_TYPE", "DISABLE_DBMGMT"


        :return: The operation of this ChangeMysqlDatabaseManagementTypeDetails.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this ChangeMysqlDatabaseManagementTypeDetails.
        The type of operation to perform: update managementType, enable or disable database management.


        :param operation: The operation of this ChangeMysqlDatabaseManagementTypeDetails.
        :type: str
        """
        allowed_values = ["ENABLE_DBMGMT", "UPDATE_DBMGMT_TYPE", "DISABLE_DBMGMT"]
        if not value_allowed_none_or_none_sentinel(operation, allowed_values):
            raise ValueError(
                f"Invalid value for `operation`, must be None or one of {allowed_values}"
            )
        self._operation = operation

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
