# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .dbm_resource import DbmResource
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudExadataStorageGridSummary(DbmResource):
    """
    The Exadata storage server grid of the Exadata infrastructure.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudExadataStorageGridSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.CloudExadataStorageGridSummary.resource_type` attribute
        of this class is ``CLOUD_STORAGE_GRID_SUMMARY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CloudExadataStorageGridSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this CloudExadataStorageGridSummary.
        :type display_name: str

        :param version:
            The value to assign to the version property of this CloudExadataStorageGridSummary.
        :type version: str

        :param internal_id:
            The value to assign to the internal_id property of this CloudExadataStorageGridSummary.
        :type internal_id: str

        :param status:
            The value to assign to the status property of this CloudExadataStorageGridSummary.
        :type status: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CloudExadataStorageGridSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this CloudExadataStorageGridSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CloudExadataStorageGridSummary.
        :type time_updated: datetime

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CloudExadataStorageGridSummary.
        :type lifecycle_details: str

        :param additional_details:
            The value to assign to the additional_details property of this CloudExadataStorageGridSummary.
        :type additional_details: dict(str, str)

        :param resource_type:
            The value to assign to the resource_type property of this CloudExadataStorageGridSummary.
            Allowed values for this property are: "INFRASTRUCTURE_SUMMARY", "INFRASTRUCTURE", "STORAGE_SERVER_SUMMARY", "STORAGE_SERVER", "STORAGE_GRID_SUMMARY", "STORAGE_GRID", "STORAGE_CONNECTOR_SUMMARY", "STORAGE_CONNECTOR", "DATABASE_SYSTEM_SUMMARY", "DATABASE_SUMMARY", "VM_CLUSTER_SUMMARY", "CLOUD_INFRASTRUCTURE_SUMMARY", "CLOUD_INFRASTRUCTURE", "CLOUD_STORAGE_SERVER_SUMMARY", "CLOUD_STORAGE_SERVER", "CLOUD_STORAGE_GRID_SUMMARY", "CLOUD_STORAGE_GRID", "CLOUD_STORAGE_CONNECTOR_SUMMARY", "CLOUD_STORAGE_CONNECTOR", "MANAGED_DATABASE_SUMMARY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_type: str

        :param server_count:
            The value to assign to the server_count property of this CloudExadataStorageGridSummary.
        :type server_count: int

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'version': 'str',
            'internal_id': 'str',
            'status': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_details': 'str',
            'additional_details': 'dict(str, str)',
            'resource_type': 'str',
            'server_count': 'int'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'version': 'version',
            'internal_id': 'internalId',
            'status': 'status',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_details': 'lifecycleDetails',
            'additional_details': 'additionalDetails',
            'resource_type': 'resourceType',
            'server_count': 'serverCount'
        }
        self._id = None
        self._display_name = None
        self._version = None
        self._internal_id = None
        self._status = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_details = None
        self._additional_details = None
        self._resource_type = None
        self._server_count = None
        self._resource_type = 'CLOUD_STORAGE_GRID_SUMMARY'

    @property
    def server_count(self):
        """
        Gets the server_count of this CloudExadataStorageGridSummary.
        The number of Exadata storage servers in the Exadata infrastructure.


        :return: The server_count of this CloudExadataStorageGridSummary.
        :rtype: int
        """
        return self._server_count

    @server_count.setter
    def server_count(self, server_count):
        """
        Sets the server_count of this CloudExadataStorageGridSummary.
        The number of Exadata storage servers in the Exadata infrastructure.


        :param server_count: The server_count of this CloudExadataStorageGridSummary.
        :type: int
        """
        self._server_count = server_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
