# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCloudExadataStorageConnectorDetails(object):
    """
    The details required to create the connector to the Exadata storage server.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCloudExadataStorageConnectorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_server_id:
            The value to assign to the storage_server_id property of this CreateCloudExadataStorageConnectorDetails.
        :type storage_server_id: str

        :param agent_id:
            The value to assign to the agent_id property of this CreateCloudExadataStorageConnectorDetails.
        :type agent_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateCloudExadataStorageConnectorDetails.
        :type display_name: str

        :param connection_uri:
            The value to assign to the connection_uri property of this CreateCloudExadataStorageConnectorDetails.
        :type connection_uri: str

        :param credential_info:
            The value to assign to the credential_info property of this CreateCloudExadataStorageConnectorDetails.
        :type credential_info: oci.database_management.models.RestCredential

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCloudExadataStorageConnectorDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCloudExadataStorageConnectorDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'storage_server_id': 'str',
            'agent_id': 'str',
            'display_name': 'str',
            'connection_uri': 'str',
            'credential_info': 'RestCredential',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'storage_server_id': 'storageServerId',
            'agent_id': 'agentId',
            'display_name': 'displayName',
            'connection_uri': 'connectionUri',
            'credential_info': 'credentialInfo',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._storage_server_id = None
        self._agent_id = None
        self._display_name = None
        self._connection_uri = None
        self._credential_info = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def storage_server_id(self):
        """
        **[Required]** Gets the storage_server_id of this CreateCloudExadataStorageConnectorDetails.
        The `OCID`__ of the Exadata storage server.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The storage_server_id of this CreateCloudExadataStorageConnectorDetails.
        :rtype: str
        """
        return self._storage_server_id

    @storage_server_id.setter
    def storage_server_id(self, storage_server_id):
        """
        Sets the storage_server_id of this CreateCloudExadataStorageConnectorDetails.
        The `OCID`__ of the Exadata storage server.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param storage_server_id: The storage_server_id of this CreateCloudExadataStorageConnectorDetails.
        :type: str
        """
        self._storage_server_id = storage_server_id

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this CreateCloudExadataStorageConnectorDetails.
        The `OCID`__ of the agent for the Exadata storage server.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The agent_id of this CreateCloudExadataStorageConnectorDetails.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this CreateCloudExadataStorageConnectorDetails.
        The `OCID`__ of the agent for the Exadata storage server.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param agent_id: The agent_id of this CreateCloudExadataStorageConnectorDetails.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateCloudExadataStorageConnectorDetails.
        The name of the Exadata storage server connector.


        :return: The display_name of this CreateCloudExadataStorageConnectorDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCloudExadataStorageConnectorDetails.
        The name of the Exadata storage server connector.


        :param display_name: The display_name of this CreateCloudExadataStorageConnectorDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def connection_uri(self):
        """
        **[Required]** Gets the connection_uri of this CreateCloudExadataStorageConnectorDetails.
        The unique string of the connection. For example, \"https://<storage-server-name>/MS/RESTService/\".


        :return: The connection_uri of this CreateCloudExadataStorageConnectorDetails.
        :rtype: str
        """
        return self._connection_uri

    @connection_uri.setter
    def connection_uri(self, connection_uri):
        """
        Sets the connection_uri of this CreateCloudExadataStorageConnectorDetails.
        The unique string of the connection. For example, \"https://<storage-server-name>/MS/RESTService/\".


        :param connection_uri: The connection_uri of this CreateCloudExadataStorageConnectorDetails.
        :type: str
        """
        self._connection_uri = connection_uri

    @property
    def credential_info(self):
        """
        **[Required]** Gets the credential_info of this CreateCloudExadataStorageConnectorDetails.

        :return: The credential_info of this CreateCloudExadataStorageConnectorDetails.
        :rtype: oci.database_management.models.RestCredential
        """
        return self._credential_info

    @credential_info.setter
    def credential_info(self, credential_info):
        """
        Sets the credential_info of this CreateCloudExadataStorageConnectorDetails.

        :param credential_info: The credential_info of this CreateCloudExadataStorageConnectorDetails.
        :type: oci.database_management.models.RestCredential
        """
        self._credential_info = credential_info

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCloudExadataStorageConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateCloudExadataStorageConnectorDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCloudExadataStorageConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateCloudExadataStorageConnectorDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCloudExadataStorageConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateCloudExadataStorageConnectorDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCloudExadataStorageConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateCloudExadataStorageConnectorDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
