# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadataInfrastructureFleetSummary(object):
    """
    A summary of the inventory count grouped by Exadata infrastructure deployment type, and the metrics that
    describe the aggregated usage of CPU, storage, and so on of all Exadata infrastructures in the fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadataInfrastructureFleetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param aggregated_metrics:
            The value to assign to the aggregated_metrics property of this ExadataInfrastructureFleetSummary.
        :type aggregated_metrics: list[oci.database_management.models.ExadataFleetMetricSummaryDefinition]

        :param inventory:
            The value to assign to the inventory property of this ExadataInfrastructureFleetSummary.
        :type inventory: list[oci.database_management.models.ExadataInfrastructureFleetStatusByCategory]

        """
        self.swagger_types = {
            'aggregated_metrics': 'list[ExadataFleetMetricSummaryDefinition]',
            'inventory': 'list[ExadataInfrastructureFleetStatusByCategory]'
        }
        self.attribute_map = {
            'aggregated_metrics': 'aggregatedMetrics',
            'inventory': 'inventory'
        }
        self._aggregated_metrics = None
        self._inventory = None

    @property
    def aggregated_metrics(self):
        """
        Gets the aggregated_metrics of this ExadataInfrastructureFleetSummary.
        A list of Exadata infrastructures present in the fleet and their usage metrics.


        :return: The aggregated_metrics of this ExadataInfrastructureFleetSummary.
        :rtype: list[oci.database_management.models.ExadataFleetMetricSummaryDefinition]
        """
        return self._aggregated_metrics

    @aggregated_metrics.setter
    def aggregated_metrics(self, aggregated_metrics):
        """
        Sets the aggregated_metrics of this ExadataInfrastructureFleetSummary.
        A list of Exadata infrastructures present in the fleet and their usage metrics.


        :param aggregated_metrics: The aggregated_metrics of this ExadataInfrastructureFleetSummary.
        :type: list[oci.database_management.models.ExadataFleetMetricSummaryDefinition]
        """
        self._aggregated_metrics = aggregated_metrics

    @property
    def inventory(self):
        """
        Gets the inventory of this ExadataInfrastructureFleetSummary.
        A list of the Exadata infrastructures in the fleet.


        :return: The inventory of this ExadataInfrastructureFleetSummary.
        :rtype: list[oci.database_management.models.ExadataInfrastructureFleetStatusByCategory]
        """
        return self._inventory

    @inventory.setter
    def inventory(self, inventory):
        """
        Sets the inventory of this ExadataInfrastructureFleetSummary.
        A list of the Exadata infrastructures in the fleet.


        :param inventory: The inventory of this ExadataInfrastructureFleetSummary.
        :type: list[oci.database_management.models.ExadataInfrastructureFleetStatusByCategory]
        """
        self._inventory = inventory

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
