# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PerformanceMetrics(object):
    """
    The Data Guard performance metric details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PerformanceMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this PerformanceMetrics.
        :type name: str

        :param dimensions:
            The value to assign to the dimensions property of this PerformanceMetrics.
        :type dimensions: object

        :param metadata:
            The value to assign to the metadata property of this PerformanceMetrics.
        :type metadata: object

        :param datapoints:
            The value to assign to the datapoints property of this PerformanceMetrics.
        :type datapoints: list[oci.database_management.models.DataPoints]

        """
        self.swagger_types = {
            'name': 'str',
            'dimensions': 'object',
            'metadata': 'object',
            'datapoints': 'list[DataPoints]'
        }
        self.attribute_map = {
            'name': 'name',
            'dimensions': 'dimensions',
            'metadata': 'metadata',
            'datapoints': 'datapoints'
        }
        self._name = None
        self._dimensions = None
        self._metadata = None
        self._datapoints = None

    @property
    def name(self):
        """
        Gets the name of this PerformanceMetrics.
        The name of the metric.


        :return: The name of this PerformanceMetrics.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PerformanceMetrics.
        The name of the metric.


        :param name: The name of this PerformanceMetrics.
        :type: str
        """
        self._name = name

    @property
    def dimensions(self):
        """
        Gets the dimensions of this PerformanceMetrics.
        The dimensions of the Data Guard performance metrics, such as primary database ID, primary database unique name.


        :return: The dimensions of this PerformanceMetrics.
        :rtype: object
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this PerformanceMetrics.
        The dimensions of the Data Guard performance metrics, such as primary database ID, primary database unique name.


        :param dimensions: The dimensions of this PerformanceMetrics.
        :type: object
        """
        self._dimensions = dimensions

    @property
    def metadata(self):
        """
        Gets the metadata of this PerformanceMetrics.
        The metadata of the metric, such as Unit.


        :return: The metadata of this PerformanceMetrics.
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this PerformanceMetrics.
        The metadata of the metric, such as Unit.


        :param metadata: The metadata of this PerformanceMetrics.
        :type: object
        """
        self._metadata = metadata

    @property
    def datapoints(self):
        """
        Gets the datapoints of this PerformanceMetrics.
        The aggregated datapoints of the metric.


        :return: The datapoints of this PerformanceMetrics.
        :rtype: list[oci.database_management.models.DataPoints]
        """
        return self._datapoints

    @datapoints.setter
    def datapoints(self, datapoints):
        """
        Sets the datapoints of this PerformanceMetrics.
        The aggregated datapoints of the metric.


        :param datapoints: The datapoints of this PerformanceMetrics.
        :type: list[oci.database_management.models.DataPoints]
        """
        self._datapoints = datapoints

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
