# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssessorCheckGroup(object):
    """
    Assessor Check Group
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssessorCheckGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AssessorCheckGroup.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this AssessorCheckGroup.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AssessorCheckGroup.
        :type description: str

        :param is_expanded:
            The value to assign to the is_expanded property of this AssessorCheckGroup.
        :type is_expanded: bool

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'is_expanded': 'bool'
        }
        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'is_expanded': 'isExpanded'
        }
        self._name = None
        self._display_name = None
        self._description = None
        self._is_expanded = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AssessorCheckGroup.
        Assessor Check Group name, e.g. ADVANCED.


        :return: The name of this AssessorCheckGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssessorCheckGroup.
        Assessor Check Group name, e.g. ADVANCED.


        :param name: The name of this AssessorCheckGroup.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AssessorCheckGroup.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this AssessorCheckGroup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssessorCheckGroup.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this AssessorCheckGroup.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AssessorCheckGroup.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this AssessorCheckGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AssessorCheckGroup.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this AssessorCheckGroup.
        :type: str
        """
        self._description = description

    @property
    def is_expanded(self):
        """
        Gets the is_expanded of this AssessorCheckGroup.
        True if the group is expanded, false otherwise.


        :return: The is_expanded of this AssessorCheckGroup.
        :rtype: bool
        """
        return self._is_expanded

    @is_expanded.setter
    def is_expanded(self, is_expanded):
        """
        Sets the is_expanded of this AssessorCheckGroup.
        True if the group is expanded, false otherwise.


        :param is_expanded: The is_expanded of this AssessorCheckGroup.
        :type: bool
        """
        self._is_expanded = is_expanded

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
