# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssessorCheckSummary(object):
    """
    Assessor Check Summary
    """

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "PENDING_APPROVAL"
    ASSESSOR_CHECK_STATE_PENDING_APPROVAL = "PENDING_APPROVAL"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "PENDING_RESOLUTION"
    ASSESSOR_CHECK_STATE_PENDING_RESOLUTION = "PENDING_RESOLUTION"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "PENDING_VALIDATION"
    ASSESSOR_CHECK_STATE_PENDING_VALIDATION = "PENDING_VALIDATION"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "NOT_ACKNOWLEDGED"
    ASSESSOR_CHECK_STATE_NOT_ACKNOWLEDGED = "NOT_ACKNOWLEDGED"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "APPROVED"
    ASSESSOR_CHECK_STATE_APPROVED = "APPROVED"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "ACKNOWLEDGED"
    ASSESSOR_CHECK_STATE_ACKNOWLEDGED = "ACKNOWLEDGED"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "VALIDATED"
    ASSESSOR_CHECK_STATE_VALIDATED = "VALIDATED"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "PASSED"
    ASSESSOR_CHECK_STATE_PASSED = "PASSED"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "PENDING"
    ASSESSOR_CHECK_STATE_PENDING = "PENDING"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "STARTED"
    ASSESSOR_CHECK_STATE_STARTED = "STARTED"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "COMPLETED"
    ASSESSOR_CHECK_STATE_COMPLETED = "COMPLETED"

    #: A constant which can be used with the assessor_check_state property of a AssessorCheckSummary.
    #: This constant has a value of "FAILED"
    ASSESSOR_CHECK_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new AssessorCheckSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AssessorCheckSummary.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this AssessorCheckSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AssessorCheckSummary.
        :type description: str

        :param assessor_check_group:
            The value to assign to the assessor_check_group property of this AssessorCheckSummary.
        :type assessor_check_group: oci.database_migration.models.AssessorCheckGroup

        :param help_link_url:
            The value to assign to the help_link_url property of this AssessorCheckSummary.
        :type help_link_url: str

        :param help_link_text:
            The value to assign to the help_link_text property of this AssessorCheckSummary.
        :type help_link_text: str

        :param assessor_check_state:
            The value to assign to the assessor_check_state property of this AssessorCheckSummary.
            Allowed values for this property are: "PENDING_APPROVAL", "PENDING_RESOLUTION", "PENDING_VALIDATION", "NOT_ACKNOWLEDGED", "APPROVED", "ACKNOWLEDGED", "VALIDATED", "PASSED", "PENDING", "STARTED", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type assessor_check_state: str

        :param check_action:
            The value to assign to the check_action property of this AssessorCheckSummary.
        :type check_action: oci.database_migration.models.AssessorCheckAction

        :param key:
            The value to assign to the key property of this AssessorCheckSummary.
        :type key: str

        :param issue:
            The value to assign to the issue property of this AssessorCheckSummary.
        :type issue: str

        :param impact:
            The value to assign to the impact property of this AssessorCheckSummary.
        :type impact: str

        :param action:
            The value to assign to the action property of this AssessorCheckSummary.
        :type action: str

        :param fixup_script_location:
            The value to assign to the fixup_script_location property of this AssessorCheckSummary.
        :type fixup_script_location: str

        :param is_exclusion_allowed:
            The value to assign to the is_exclusion_allowed property of this AssessorCheckSummary.
        :type is_exclusion_allowed: bool

        :param metadata:
            The value to assign to the metadata property of this AssessorCheckSummary.
        :type metadata: oci.database_migration.models.ObjectMetadata

        :param columns:
            The value to assign to the columns property of this AssessorCheckSummary.
        :type columns: list[oci.database_migration.models.AdvisorReportCheckColumn]

        :param object_count:
            The value to assign to the object_count property of this AssessorCheckSummary.
        :type object_count: int

        :param objects_display_name:
            The value to assign to the objects_display_name property of this AssessorCheckSummary.
        :type objects_display_name: str

        :param log_location:
            The value to assign to the log_location property of this AssessorCheckSummary.
        :type log_location: oci.database_migration.models.LogLocationBucketDetails

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'assessor_check_group': 'AssessorCheckGroup',
            'help_link_url': 'str',
            'help_link_text': 'str',
            'assessor_check_state': 'str',
            'check_action': 'AssessorCheckAction',
            'key': 'str',
            'issue': 'str',
            'impact': 'str',
            'action': 'str',
            'fixup_script_location': 'str',
            'is_exclusion_allowed': 'bool',
            'metadata': 'ObjectMetadata',
            'columns': 'list[AdvisorReportCheckColumn]',
            'object_count': 'int',
            'objects_display_name': 'str',
            'log_location': 'LogLocationBucketDetails'
        }
        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'assessor_check_group': 'assessorCheckGroup',
            'help_link_url': 'helpLinkUrl',
            'help_link_text': 'helpLinkText',
            'assessor_check_state': 'assessorCheckState',
            'check_action': 'checkAction',
            'key': 'key',
            'issue': 'issue',
            'impact': 'impact',
            'action': 'action',
            'fixup_script_location': 'fixupScriptLocation',
            'is_exclusion_allowed': 'isExclusionAllowed',
            'metadata': 'metadata',
            'columns': 'columns',
            'object_count': 'objectCount',
            'objects_display_name': 'objectsDisplayName',
            'log_location': 'logLocation'
        }
        self._name = None
        self._display_name = None
        self._description = None
        self._assessor_check_group = None
        self._help_link_url = None
        self._help_link_text = None
        self._assessor_check_state = None
        self._check_action = None
        self._key = None
        self._issue = None
        self._impact = None
        self._action = None
        self._fixup_script_location = None
        self._is_exclusion_allowed = None
        self._metadata = None
        self._columns = None
        self._object_count = None
        self._objects_display_name = None
        self._log_location = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AssessorCheckSummary.
        The Name of the Check.


        :return: The name of this AssessorCheckSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssessorCheckSummary.
        The Name of the Check.


        :param name: The name of this AssessorCheckSummary.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AssessorCheckSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this AssessorCheckSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssessorCheckSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this AssessorCheckSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AssessorCheckSummary.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this AssessorCheckSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AssessorCheckSummary.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this AssessorCheckSummary.
        :type: str
        """
        self._description = description

    @property
    def assessor_check_group(self):
        """
        **[Required]** Gets the assessor_check_group of this AssessorCheckSummary.

        :return: The assessor_check_group of this AssessorCheckSummary.
        :rtype: oci.database_migration.models.AssessorCheckGroup
        """
        return self._assessor_check_group

    @assessor_check_group.setter
    def assessor_check_group(self, assessor_check_group):
        """
        Sets the assessor_check_group of this AssessorCheckSummary.

        :param assessor_check_group: The assessor_check_group of this AssessorCheckSummary.
        :type: oci.database_migration.models.AssessorCheckGroup
        """
        self._assessor_check_group = assessor_check_group

    @property
    def help_link_url(self):
        """
        Gets the help_link_url of this AssessorCheckSummary.
        The Help URL.


        :return: The help_link_url of this AssessorCheckSummary.
        :rtype: str
        """
        return self._help_link_url

    @help_link_url.setter
    def help_link_url(self, help_link_url):
        """
        Sets the help_link_url of this AssessorCheckSummary.
        The Help URL.


        :param help_link_url: The help_link_url of this AssessorCheckSummary.
        :type: str
        """
        self._help_link_url = help_link_url

    @property
    def help_link_text(self):
        """
        Gets the help_link_text of this AssessorCheckSummary.
        The Help link text.


        :return: The help_link_text of this AssessorCheckSummary.
        :rtype: str
        """
        return self._help_link_text

    @help_link_text.setter
    def help_link_text(self, help_link_text):
        """
        Sets the help_link_text of this AssessorCheckSummary.
        The Help link text.


        :param help_link_text: The help_link_text of this AssessorCheckSummary.
        :type: str
        """
        self._help_link_text = help_link_text

    @property
    def assessor_check_state(self):
        """
        **[Required]** Gets the assessor_check_state of this AssessorCheckSummary.
        The current state of the Assessor Check.

        Allowed values for this property are: "PENDING_APPROVAL", "PENDING_RESOLUTION", "PENDING_VALIDATION", "NOT_ACKNOWLEDGED", "APPROVED", "ACKNOWLEDGED", "VALIDATED", "PASSED", "PENDING", "STARTED", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The assessor_check_state of this AssessorCheckSummary.
        :rtype: str
        """
        return self._assessor_check_state

    @assessor_check_state.setter
    def assessor_check_state(self, assessor_check_state):
        """
        Sets the assessor_check_state of this AssessorCheckSummary.
        The current state of the Assessor Check.


        :param assessor_check_state: The assessor_check_state of this AssessorCheckSummary.
        :type: str
        """
        allowed_values = ["PENDING_APPROVAL", "PENDING_RESOLUTION", "PENDING_VALIDATION", "NOT_ACKNOWLEDGED", "APPROVED", "ACKNOWLEDGED", "VALIDATED", "PASSED", "PENDING", "STARTED", "COMPLETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(assessor_check_state, allowed_values):
            assessor_check_state = 'UNKNOWN_ENUM_VALUE'
        self._assessor_check_state = assessor_check_state

    @property
    def check_action(self):
        """
        Gets the check_action of this AssessorCheckSummary.

        :return: The check_action of this AssessorCheckSummary.
        :rtype: oci.database_migration.models.AssessorCheckAction
        """
        return self._check_action

    @check_action.setter
    def check_action(self, check_action):
        """
        Sets the check_action of this AssessorCheckSummary.

        :param check_action: The check_action of this AssessorCheckSummary.
        :type: oci.database_migration.models.AssessorCheckAction
        """
        self._check_action = check_action

    @property
    def key(self):
        """
        Gets the key of this AssessorCheckSummary.
        Pre-Migration \u0441heck id.


        :return: The key of this AssessorCheckSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this AssessorCheckSummary.
        Pre-Migration \u0441heck id.


        :param key: The key of this AssessorCheckSummary.
        :type: str
        """
        self._key = key

    @property
    def issue(self):
        """
        Gets the issue of this AssessorCheckSummary.
        Description of the issue.


        :return: The issue of this AssessorCheckSummary.
        :rtype: str
        """
        return self._issue

    @issue.setter
    def issue(self, issue):
        """
        Sets the issue of this AssessorCheckSummary.
        Description of the issue.


        :param issue: The issue of this AssessorCheckSummary.
        :type: str
        """
        self._issue = issue

    @property
    def impact(self):
        """
        Gets the impact of this AssessorCheckSummary.
        Impact of the issue on data migration.


        :return: The impact of this AssessorCheckSummary.
        :rtype: str
        """
        return self._impact

    @impact.setter
    def impact(self, impact):
        """
        Sets the impact of this AssessorCheckSummary.
        Impact of the issue on data migration.


        :param impact: The impact of this AssessorCheckSummary.
        :type: str
        """
        self._impact = impact

    @property
    def action(self):
        """
        Gets the action of this AssessorCheckSummary.
        Fixing the issue.


        :return: The action of this AssessorCheckSummary.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this AssessorCheckSummary.
        Fixing the issue.


        :param action: The action of this AssessorCheckSummary.
        :type: str
        """
        self._action = action

    @property
    def fixup_script_location(self):
        """
        Gets the fixup_script_location of this AssessorCheckSummary.
        The path to the fixup script for this check.


        :return: The fixup_script_location of this AssessorCheckSummary.
        :rtype: str
        """
        return self._fixup_script_location

    @fixup_script_location.setter
    def fixup_script_location(self, fixup_script_location):
        """
        Sets the fixup_script_location of this AssessorCheckSummary.
        The path to the fixup script for this check.


        :param fixup_script_location: The fixup_script_location of this AssessorCheckSummary.
        :type: str
        """
        self._fixup_script_location = fixup_script_location

    @property
    def is_exclusion_allowed(self):
        """
        Gets the is_exclusion_allowed of this AssessorCheckSummary.
        If false, objects cannot be excluded from migration.


        :return: The is_exclusion_allowed of this AssessorCheckSummary.
        :rtype: bool
        """
        return self._is_exclusion_allowed

    @is_exclusion_allowed.setter
    def is_exclusion_allowed(self, is_exclusion_allowed):
        """
        Sets the is_exclusion_allowed of this AssessorCheckSummary.
        If false, objects cannot be excluded from migration.


        :param is_exclusion_allowed: The is_exclusion_allowed of this AssessorCheckSummary.
        :type: bool
        """
        self._is_exclusion_allowed = is_exclusion_allowed

    @property
    def metadata(self):
        """
        Gets the metadata of this AssessorCheckSummary.

        :return: The metadata of this AssessorCheckSummary.
        :rtype: oci.database_migration.models.ObjectMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this AssessorCheckSummary.

        :param metadata: The metadata of this AssessorCheckSummary.
        :type: oci.database_migration.models.ObjectMetadata
        """
        self._metadata = metadata

    @property
    def columns(self):
        """
        Gets the columns of this AssessorCheckSummary.
        Array of the column of the objects table.


        :return: The columns of this AssessorCheckSummary.
        :rtype: list[oci.database_migration.models.AdvisorReportCheckColumn]
        """
        return self._columns

    @columns.setter
    def columns(self, columns):
        """
        Sets the columns of this AssessorCheckSummary.
        Array of the column of the objects table.


        :param columns: The columns of this AssessorCheckSummary.
        :type: list[oci.database_migration.models.AdvisorReportCheckColumn]
        """
        self._columns = columns

    @property
    def object_count(self):
        """
        Gets the object_count of this AssessorCheckSummary.
        Number of database objects to migrate.


        :return: The object_count of this AssessorCheckSummary.
        :rtype: int
        """
        return self._object_count

    @object_count.setter
    def object_count(self, object_count):
        """
        Sets the object_count of this AssessorCheckSummary.
        Number of database objects to migrate.


        :param object_count: The object_count of this AssessorCheckSummary.
        :type: int
        """
        self._object_count = object_count

    @property
    def objects_display_name(self):
        """
        Gets the objects_display_name of this AssessorCheckSummary.
        The objects display name.


        :return: The objects_display_name of this AssessorCheckSummary.
        :rtype: str
        """
        return self._objects_display_name

    @objects_display_name.setter
    def objects_display_name(self, objects_display_name):
        """
        Sets the objects_display_name of this AssessorCheckSummary.
        The objects display name.


        :param objects_display_name: The objects_display_name of this AssessorCheckSummary.
        :type: str
        """
        self._objects_display_name = objects_display_name

    @property
    def log_location(self):
        """
        Gets the log_location of this AssessorCheckSummary.

        :return: The log_location of this AssessorCheckSummary.
        :rtype: oci.database_migration.models.LogLocationBucketDetails
        """
        return self._log_location

    @log_location.setter
    def log_location(self, log_location):
        """
        Sets the log_location of this AssessorCheckSummary.

        :param log_location: The log_location of this AssessorCheckSummary.
        :type: oci.database_migration.models.LogLocationBucketDetails
        """
        self._log_location = log_location

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
