# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateConnectionDetails(object):
    """
    The information about a new Connection.
    """

    #: A constant which can be used with the connection_type property of a CreateConnectionDetails.
    #: This constant has a value of "MYSQL"
    CONNECTION_TYPE_MYSQL = "MYSQL"

    #: A constant which can be used with the connection_type property of a CreateConnectionDetails.
    #: This constant has a value of "ORACLE"
    CONNECTION_TYPE_ORACLE = "ORACLE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateConnectionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_migration.models.CreateMysqlConnectionDetails`
        * :class:`~oci.database_migration.models.CreateOracleConnectionDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_type:
            The value to assign to the connection_type property of this CreateConnectionDetails.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type connection_type: str

        :param display_name:
            The value to assign to the display_name property of this CreateConnectionDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateConnectionDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateConnectionDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateConnectionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateConnectionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param vault_id:
            The value to assign to the vault_id property of this CreateConnectionDetails.
        :type vault_id: str

        :param key_id:
            The value to assign to the key_id property of this CreateConnectionDetails.
        :type key_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateConnectionDetails.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateConnectionDetails.
        :type nsg_ids: list[str]

        :param username:
            The value to assign to the username property of this CreateConnectionDetails.
        :type username: str

        :param password:
            The value to assign to the password property of this CreateConnectionDetails.
        :type password: str

        :param replication_username:
            The value to assign to the replication_username property of this CreateConnectionDetails.
        :type replication_username: str

        :param replication_password:
            The value to assign to the replication_password property of this CreateConnectionDetails.
        :type replication_password: str

        """
        self.swagger_types = {
            'connection_type': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'vault_id': 'str',
            'key_id': 'str',
            'subnet_id': 'str',
            'nsg_ids': 'list[str]',
            'username': 'str',
            'password': 'str',
            'replication_username': 'str',
            'replication_password': 'str'
        }
        self.attribute_map = {
            'connection_type': 'connectionType',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'vault_id': 'vaultId',
            'key_id': 'keyId',
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds',
            'username': 'username',
            'password': 'password',
            'replication_username': 'replicationUsername',
            'replication_password': 'replicationPassword'
        }
        self._connection_type = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._vault_id = None
        self._key_id = None
        self._subnet_id = None
        self._nsg_ids = None
        self._username = None
        self._password = None
        self._replication_username = None
        self._replication_password = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['connectionType']

        if type == 'MYSQL':
            return 'CreateMysqlConnectionDetails'

        if type == 'ORACLE':
            return 'CreateOracleConnectionDetails'
        else:
            return 'CreateConnectionDetails'

    @property
    def connection_type(self):
        """
        **[Required]** Gets the connection_type of this CreateConnectionDetails.
        Defines the type of connection. For example, ORACLE.

        Allowed values for this property are: "MYSQL", "ORACLE"


        :return: The connection_type of this CreateConnectionDetails.
        :rtype: str
        """
        return self._connection_type

    @connection_type.setter
    def connection_type(self, connection_type):
        """
        Sets the connection_type of this CreateConnectionDetails.
        Defines the type of connection. For example, ORACLE.


        :param connection_type: The connection_type of this CreateConnectionDetails.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(connection_type, allowed_values):
            raise ValueError(
                f"Invalid value for `connection_type`, must be None or one of {allowed_values}"
            )
        self._connection_type = connection_type

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateConnectionDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreateConnectionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateConnectionDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateConnectionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateConnectionDetails.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this CreateConnectionDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateConnectionDetails.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this CreateConnectionDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateConnectionDetails.
        The OCID of the compartment.


        :return: The compartment_id of this CreateConnectionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateConnectionDetails.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this CreateConnectionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateConnectionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :return: The freeform_tags of this CreateConnectionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateConnectionDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :param freeform_tags: The freeform_tags of this CreateConnectionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateConnectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateConnectionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateConnectionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateConnectionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this CreateConnectionDetails.
        OCI resource ID.


        :return: The vault_id of this CreateConnectionDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this CreateConnectionDetails.
        OCI resource ID.


        :param vault_id: The vault_id of this CreateConnectionDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def key_id(self):
        """
        **[Required]** Gets the key_id of this CreateConnectionDetails.
        The OCID of the key used in cryptographic operations.


        :return: The key_id of this CreateConnectionDetails.
        :rtype: str
        """
        return self._key_id

    @key_id.setter
    def key_id(self, key_id):
        """
        Sets the key_id of this CreateConnectionDetails.
        The OCID of the key used in cryptographic operations.


        :param key_id: The key_id of this CreateConnectionDetails.
        :type: str
        """
        self._key_id = key_id

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this CreateConnectionDetails.
        OCI resource ID.


        :return: The subnet_id of this CreateConnectionDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateConnectionDetails.
        OCI resource ID.


        :param subnet_id: The subnet_id of this CreateConnectionDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateConnectionDetails.
        An array of Network Security Group OCIDs used to define network access for Connections.


        :return: The nsg_ids of this CreateConnectionDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateConnectionDetails.
        An array of Network Security Group OCIDs used to define network access for Connections.


        :param nsg_ids: The nsg_ids of this CreateConnectionDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def username(self):
        """
        **[Required]** Gets the username of this CreateConnectionDetails.
        The username (credential) used when creating or updating this resource.


        :return: The username of this CreateConnectionDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this CreateConnectionDetails.
        The username (credential) used when creating or updating this resource.


        :param username: The username of this CreateConnectionDetails.
        :type: str
        """
        self._username = username

    @property
    def password(self):
        """
        **[Required]** Gets the password of this CreateConnectionDetails.
        The password (credential) used when creating or updating this resource.


        :return: The password of this CreateConnectionDetails.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this CreateConnectionDetails.
        The password (credential) used when creating or updating this resource.


        :param password: The password of this CreateConnectionDetails.
        :type: str
        """
        self._password = password

    @property
    def replication_username(self):
        """
        Gets the replication_username of this CreateConnectionDetails.
        The username (credential) used when creating or updating this resource.


        :return: The replication_username of this CreateConnectionDetails.
        :rtype: str
        """
        return self._replication_username

    @replication_username.setter
    def replication_username(self, replication_username):
        """
        Sets the replication_username of this CreateConnectionDetails.
        The username (credential) used when creating or updating this resource.


        :param replication_username: The replication_username of this CreateConnectionDetails.
        :type: str
        """
        self._replication_username = replication_username

    @property
    def replication_password(self):
        """
        Gets the replication_password of this CreateConnectionDetails.
        The password (credential) used when creating or updating this resource.


        :return: The replication_password of this CreateConnectionDetails.
        :rtype: str
        """
        return self._replication_password

    @replication_password.setter
    def replication_password(self, replication_password):
        """
        Sets the replication_password of this CreateConnectionDetails.
        The password (credential) used when creating or updating this resource.


        :param replication_password: The replication_password of this CreateConnectionDetails.
        :type: str
        """
        self._replication_password = replication_password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
