# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseConnectionTypeSummary(object):
    """
    Connection type e.g. ORACLE and array of technology type objects.
    """

    #: A constant which can be used with the connection_type property of a DatabaseConnectionTypeSummary.
    #: This constant has a value of "MYSQL"
    CONNECTION_TYPE_MYSQL = "MYSQL"

    #: A constant which can be used with the connection_type property of a DatabaseConnectionTypeSummary.
    #: This constant has a value of "ORACLE"
    CONNECTION_TYPE_ORACLE = "ORACLE"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseConnectionTypeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_type:
            The value to assign to the connection_type property of this DatabaseConnectionTypeSummary.
            Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type connection_type: str

        :param technology_types:
            The value to assign to the technology_types property of this DatabaseConnectionTypeSummary.
        :type technology_types: list[oci.database_migration.models.DatabaseTechnologyType]

        """
        self.swagger_types = {
            'connection_type': 'str',
            'technology_types': 'list[DatabaseTechnologyType]'
        }
        self.attribute_map = {
            'connection_type': 'connectionType',
            'technology_types': 'technologyTypes'
        }
        self._connection_type = None
        self._technology_types = None

    @property
    def connection_type(self):
        """
        **[Required]** Gets the connection_type of this DatabaseConnectionTypeSummary.
        Defines the type of connection. For example, ORACLE.

        Allowed values for this property are: "MYSQL", "ORACLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The connection_type of this DatabaseConnectionTypeSummary.
        :rtype: str
        """
        return self._connection_type

    @connection_type.setter
    def connection_type(self, connection_type):
        """
        Sets the connection_type of this DatabaseConnectionTypeSummary.
        Defines the type of connection. For example, ORACLE.


        :param connection_type: The connection_type of this DatabaseConnectionTypeSummary.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(connection_type, allowed_values):
            connection_type = 'UNKNOWN_ENUM_VALUE'
        self._connection_type = connection_type

    @property
    def technology_types(self):
        """
        Gets the technology_types of this DatabaseConnectionTypeSummary.
        Array of technology type objects


        :return: The technology_types of this DatabaseConnectionTypeSummary.
        :rtype: list[oci.database_migration.models.DatabaseTechnologyType]
        """
        return self._technology_types

    @technology_types.setter
    def technology_types(self, technology_types):
        """
        Sets the technology_types of this DatabaseConnectionTypeSummary.
        Array of technology type objects


        :param technology_types: The technology_types of this DatabaseConnectionTypeSummary.
        :type: list[oci.database_migration.models.DatabaseTechnologyType]
        """
        self._technology_types = technology_types

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
