# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseTechnologyType(object):
    """
    Technology type e.g. OCI_AUTONOMOUS_DATABASE, array of corresponding sub-types e.g. ADW_SHARED and versions.
    """

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "OCI_AUTONOMOUS_DATABASE"
    TECHNOLOGY_TYPE_OCI_AUTONOMOUS_DATABASE = "OCI_AUTONOMOUS_DATABASE"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "OCI_MYSQL"
    TECHNOLOGY_TYPE_OCI_MYSQL = "OCI_MYSQL"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "ORACLE_DATABASE"
    TECHNOLOGY_TYPE_ORACLE_DATABASE = "ORACLE_DATABASE"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "ORACLE_EXADATA"
    TECHNOLOGY_TYPE_ORACLE_EXADATA = "ORACLE_EXADATA"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "AMAZON_RDS_ORACLE"
    TECHNOLOGY_TYPE_AMAZON_RDS_ORACLE = "AMAZON_RDS_ORACLE"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "AMAZON_AURORA_MYSQL"
    TECHNOLOGY_TYPE_AMAZON_AURORA_MYSQL = "AMAZON_AURORA_MYSQL"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "AMAZON_RDS_MYSQL"
    TECHNOLOGY_TYPE_AMAZON_RDS_MYSQL = "AMAZON_RDS_MYSQL"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "AZURE_MYSQL"
    TECHNOLOGY_TYPE_AZURE_MYSQL = "AZURE_MYSQL"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "GOOGLE_CLOUD_SQL_MYSQL"
    TECHNOLOGY_TYPE_GOOGLE_CLOUD_SQL_MYSQL = "GOOGLE_CLOUD_SQL_MYSQL"

    #: A constant which can be used with the technology_type property of a DatabaseTechnologyType.
    #: This constant has a value of "MYSQL_SERVER"
    TECHNOLOGY_TYPE_MYSQL_SERVER = "MYSQL_SERVER"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseTechnologyType object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param technology_type:
            The value to assign to the technology_type property of this DatabaseTechnologyType.
            Allowed values for this property are: "OCI_AUTONOMOUS_DATABASE", "OCI_MYSQL", "ORACLE_DATABASE", "ORACLE_EXADATA", "AMAZON_RDS_ORACLE", "AMAZON_AURORA_MYSQL", "AMAZON_RDS_MYSQL", "AZURE_MYSQL", "GOOGLE_CLOUD_SQL_MYSQL", "MYSQL_SERVER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type technology_type: str

        :param technology_sub_types:
            The value to assign to the technology_sub_types property of this DatabaseTechnologyType.
        :type technology_sub_types: list[oci.database_migration.models.DatabaseTechnologySubType]

        :param database_versions:
            The value to assign to the database_versions property of this DatabaseTechnologyType.
        :type database_versions: list[str]

        """
        self.swagger_types = {
            'technology_type': 'str',
            'technology_sub_types': 'list[DatabaseTechnologySubType]',
            'database_versions': 'list[str]'
        }
        self.attribute_map = {
            'technology_type': 'technologyType',
            'technology_sub_types': 'technologySubTypes',
            'database_versions': 'databaseVersions'
        }
        self._technology_type = None
        self._technology_sub_types = None
        self._database_versions = None

    @property
    def technology_type(self):
        """
        **[Required]** Gets the technology_type of this DatabaseTechnologyType.
        The technology type.

        Allowed values for this property are: "OCI_AUTONOMOUS_DATABASE", "OCI_MYSQL", "ORACLE_DATABASE", "ORACLE_EXADATA", "AMAZON_RDS_ORACLE", "AMAZON_AURORA_MYSQL", "AMAZON_RDS_MYSQL", "AZURE_MYSQL", "GOOGLE_CLOUD_SQL_MYSQL", "MYSQL_SERVER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The technology_type of this DatabaseTechnologyType.
        :rtype: str
        """
        return self._technology_type

    @technology_type.setter
    def technology_type(self, technology_type):
        """
        Sets the technology_type of this DatabaseTechnologyType.
        The technology type.


        :param technology_type: The technology_type of this DatabaseTechnologyType.
        :type: str
        """
        allowed_values = ["OCI_AUTONOMOUS_DATABASE", "OCI_MYSQL", "ORACLE_DATABASE", "ORACLE_EXADATA", "AMAZON_RDS_ORACLE", "AMAZON_AURORA_MYSQL", "AMAZON_RDS_MYSQL", "AZURE_MYSQL", "GOOGLE_CLOUD_SQL_MYSQL", "MYSQL_SERVER"]
        if not value_allowed_none_or_none_sentinel(technology_type, allowed_values):
            technology_type = 'UNKNOWN_ENUM_VALUE'
        self._technology_type = technology_type

    @property
    def technology_sub_types(self):
        """
        Gets the technology_sub_types of this DatabaseTechnologyType.
        Array of technology sub-types e.g. ADW_SHARED.


        :return: The technology_sub_types of this DatabaseTechnologyType.
        :rtype: list[oci.database_migration.models.DatabaseTechnologySubType]
        """
        return self._technology_sub_types

    @technology_sub_types.setter
    def technology_sub_types(self, technology_sub_types):
        """
        Sets the technology_sub_types of this DatabaseTechnologyType.
        Array of technology sub-types e.g. ADW_SHARED.


        :param technology_sub_types: The technology_sub_types of this DatabaseTechnologyType.
        :type: list[oci.database_migration.models.DatabaseTechnologySubType]
        """
        self._technology_sub_types = technology_sub_types

    @property
    def database_versions(self):
        """
        Gets the database_versions of this DatabaseTechnologyType.
        Array of database versions


        :return: The database_versions of this DatabaseTechnologyType.
        :rtype: list[str]
        """
        return self._database_versions

    @database_versions.setter
    def database_versions(self, database_versions):
        """
        Sets the database_versions of this DatabaseTechnologyType.
        Array of database versions


        :param database_versions: The database_versions of this DatabaseTechnologyType.
        :type: list[str]
        """
        self._database_versions = database_versions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
