# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518

from .update_check_action_update_object_details import UpdateCheckActionUpdateObjectDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListUpdateCheckActionUpdateObjectDetails(UpdateCheckActionUpdateObjectDetails):
    """
    Collection of AdvisorReportCheckObjectSummary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ListUpdateCheckActionUpdateObjectDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_migration.models.ListUpdateCheckActionUpdateObjectDetails.kind` attribute
        of this class is ``LIST_OBJECTS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this ListUpdateCheckActionUpdateObjectDetails.
            Allowed values for this property are: "ALL_OBJECTS", "LIST_OBJECTS"
        :type kind: str

        :param items:
            The value to assign to the items property of this ListUpdateCheckActionUpdateObjectDetails.
        :type items: list[oci.database_migration.models.AdvisorReportCheckObjectSummary]

        """
        self.swagger_types = {
            'kind': 'str',
            'items': 'list[AdvisorReportCheckObjectSummary]'
        }
        self.attribute_map = {
            'kind': 'kind',
            'items': 'items'
        }
        self._kind = None
        self._items = None
        self._kind = 'LIST_OBJECTS'

    @property
    def items(self):
        """
        **[Required]** Gets the items of this ListUpdateCheckActionUpdateObjectDetails.
        Array of check objects.


        :return: The items of this ListUpdateCheckActionUpdateObjectDetails.
        :rtype: list[oci.database_migration.models.AdvisorReportCheckObjectSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ListUpdateCheckActionUpdateObjectDetails.
        Array of check objects.


        :param items: The items of this ListUpdateCheckActionUpdateObjectDetails.
        :type: list[oci.database_migration.models.AdvisorReportCheckObjectSummary]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
