# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAdvisorReportCheckDetails(object):
    """
    Pre-Migration extended advisor report check item update.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAdvisorReportCheckDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_reviewed:
            The value to assign to the is_reviewed property of this UpdateAdvisorReportCheckDetails.
        :type is_reviewed: bool

        """
        self.swagger_types = {
            'is_reviewed': 'bool'
        }
        self.attribute_map = {
            'is_reviewed': 'isReviewed'
        }
        self._is_reviewed = None

    @property
    def is_reviewed(self):
        """
        **[Required]** Gets the is_reviewed of this UpdateAdvisorReportCheckDetails.
        User flag for advisor report check.


        :return: The is_reviewed of this UpdateAdvisorReportCheckDetails.
        :rtype: bool
        """
        return self._is_reviewed

    @is_reviewed.setter
    def is_reviewed(self, is_reviewed):
        """
        Sets the is_reviewed of this UpdateAdvisorReportCheckDetails.
        User flag for advisor report check.


        :param is_reviewed: The is_reviewed of this UpdateAdvisorReportCheckDetails.
        :type: bool
        """
        self._is_reviewed = is_reviewed

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
