# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAdvisorReportCheckObjectsDetails(object):
    """
    Optional additional properties for update advisor report check. Default kind is LIST_OBJECTS
    """

    #: A constant which can be used with the kind property of a UpdateAdvisorReportCheckObjectsDetails.
    #: This constant has a value of "ALL_OBJECTS"
    KIND_ALL_OBJECTS = "ALL_OBJECTS"

    #: A constant which can be used with the kind property of a UpdateAdvisorReportCheckObjectsDetails.
    #: This constant has a value of "LIST_OBJECTS"
    KIND_LIST_OBJECTS = "LIST_OBJECTS"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAdvisorReportCheckObjectsDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_migration.models.AllUpdateAdvisorReportCheckObjectsDetails`
        * :class:`~oci.database_migration.models.ListUpdateAdvisorReportCheckObjectsDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this UpdateAdvisorReportCheckObjectsDetails.
            Allowed values for this property are: "ALL_OBJECTS", "LIST_OBJECTS"
        :type kind: str

        """
        self.swagger_types = {
            'kind': 'str'
        }
        self.attribute_map = {
            'kind': 'kind'
        }
        self._kind = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['kind']

        if type == 'ALL_OBJECTS':
            return 'AllUpdateAdvisorReportCheckObjectsDetails'

        if type == 'LIST_OBJECTS':
            return 'ListUpdateAdvisorReportCheckObjectsDetails'
        else:
            return 'UpdateAdvisorReportCheckObjectsDetails'

    @property
    def kind(self):
        """
        **[Required]** Gets the kind of this UpdateAdvisorReportCheckObjectsDetails.
        Type of update advisor report check. Default kind is LIST_OBJECTS

        Allowed values for this property are: "ALL_OBJECTS", "LIST_OBJECTS"


        :return: The kind of this UpdateAdvisorReportCheckObjectsDetails.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this UpdateAdvisorReportCheckObjectsDetails.
        Type of update advisor report check. Default kind is LIST_OBJECTS


        :param kind: The kind of this UpdateAdvisorReportCheckObjectsDetails.
        :type: str
        """
        allowed_values = ["ALL_OBJECTS", "LIST_OBJECTS"]
        if not value_allowed_none_or_none_sentinel(kind, allowed_values):
            raise ValueError(
                f"Invalid value for `kind`, must be None or one of {allowed_values}"
            )
        self._kind = kind

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
