# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAssessmentDetails(object):
    """
    Common Update Assessment details.
    """

    #: A constant which can be used with the database_combination property of a UpdateAssessmentDetails.
    #: This constant has a value of "MYSQL"
    DATABASE_COMBINATION_MYSQL = "MYSQL"

    #: A constant which can be used with the database_combination property of a UpdateAssessmentDetails.
    #: This constant has a value of "ORACLE"
    DATABASE_COMBINATION_ORACLE = "ORACLE"

    #: A constant which can be used with the network_speed_megabit_per_second property of a UpdateAssessmentDetails.
    #: This constant has a value of "MBPS_10"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_10 = "MBPS_10"

    #: A constant which can be used with the network_speed_megabit_per_second property of a UpdateAssessmentDetails.
    #: This constant has a value of "MBPS_100"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_100 = "MBPS_100"

    #: A constant which can be used with the network_speed_megabit_per_second property of a UpdateAssessmentDetails.
    #: This constant has a value of "MBPS_1000"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_1000 = "MBPS_1000"

    #: A constant which can be used with the network_speed_megabit_per_second property of a UpdateAssessmentDetails.
    #: This constant has a value of "MBPS_2500"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_2500 = "MBPS_2500"

    #: A constant which can be used with the network_speed_megabit_per_second property of a UpdateAssessmentDetails.
    #: This constant has a value of "MBPS_5000"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_5000 = "MBPS_5000"

    #: A constant which can be used with the network_speed_megabit_per_second property of a UpdateAssessmentDetails.
    #: This constant has a value of "MBPS_10000"
    NETWORK_SPEED_MEGABIT_PER_SECOND_MBPS_10000 = "MBPS_10000"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_10_MINUTES"
    ACCEPTABLE_DOWNTIME_LESS_THAN_10_MINUTES = "LESS_THAN_10_MINUTES"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_1_HOUR"
    ACCEPTABLE_DOWNTIME_LESS_THAN_1_HOUR = "LESS_THAN_1_HOUR"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_4_HOURS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_4_HOURS = "LESS_THAN_4_HOURS"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_8_HOURS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_8_HOURS = "LESS_THAN_8_HOURS"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_12_HOURS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_12_HOURS = "LESS_THAN_12_HOURS"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_1_DAY"
    ACCEPTABLE_DOWNTIME_LESS_THAN_1_DAY = "LESS_THAN_1_DAY"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_2_DAYS"
    ACCEPTABLE_DOWNTIME_LESS_THAN_2_DAYS = "LESS_THAN_2_DAYS"

    #: A constant which can be used with the acceptable_downtime property of a UpdateAssessmentDetails.
    #: This constant has a value of "MORE_THAN_2_DAYS"
    ACCEPTABLE_DOWNTIME_MORE_THAN_2_DAYS = "MORE_THAN_2_DAYS"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "LESS_THAN_1GB"
    DATABASE_DATA_SIZE_LESS_THAN_1_GB = "LESS_THAN_1GB"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "GB_1_10"
    DATABASE_DATA_SIZE_GB_1_10 = "GB_1_10"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "GB_10_50"
    DATABASE_DATA_SIZE_GB_10_50 = "GB_10_50"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "GB_50_100"
    DATABASE_DATA_SIZE_GB_50_100 = "GB_50_100"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "GB_100_500"
    DATABASE_DATA_SIZE_GB_100_500 = "GB_100_500"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "GB_500_TB_1"
    DATABASE_DATA_SIZE_GB_500_TB_1 = "GB_500_TB_1"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "TB_1_3"
    DATABASE_DATA_SIZE_TB_1_3 = "TB_1_3"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "TB_3_10"
    DATABASE_DATA_SIZE_TB_3_10 = "TB_3_10"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "TB_10_50"
    DATABASE_DATA_SIZE_TB_10_50 = "TB_10_50"

    #: A constant which can be used with the database_data_size property of a UpdateAssessmentDetails.
    #: This constant has a value of "GREATER_THAN_50TB"
    DATABASE_DATA_SIZE_GREATER_THAN_50_TB = "GREATER_THAN_50TB"

    #: A constant which can be used with the ddl_expectation property of a UpdateAssessmentDetails.
    #: This constant has a value of "DDL_EXPECTED"
    DDL_EXPECTATION_DDL_EXPECTED = "DDL_EXPECTED"

    #: A constant which can be used with the ddl_expectation property of a UpdateAssessmentDetails.
    #: This constant has a value of "DDL_NOT_EXPECTED"
    DDL_EXPECTATION_DDL_NOT_EXPECTED = "DDL_NOT_EXPECTED"

    #: A constant which can be used with the creation_type property of a UpdateAssessmentDetails.
    #: This constant has a value of "CREATE_ONLY"
    CREATION_TYPE_CREATE_ONLY = "CREATE_ONLY"

    #: A constant which can be used with the creation_type property of a UpdateAssessmentDetails.
    #: This constant has a value of "CREATE_AND_RUN_ASSESSORS"
    CREATION_TYPE_CREATE_AND_RUN_ASSESSORS = "CREATE_AND_RUN_ASSESSORS"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAssessmentDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_migration.models.UpdateMySqlAssessmentDetails`
        * :class:`~oci.database_migration.models.UpdateOracleAssessmentDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateAssessmentDetails.
        :type description: str

        :param database_combination:
            The value to assign to the database_combination property of this UpdateAssessmentDetails.
            Allowed values for this property are: "MYSQL", "ORACLE"
        :type database_combination: str

        :param display_name:
            The value to assign to the display_name property of this UpdateAssessmentDetails.
        :type display_name: str

        :param network_speed_megabit_per_second:
            The value to assign to the network_speed_megabit_per_second property of this UpdateAssessmentDetails.
            Allowed values for this property are: "MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000"
        :type network_speed_megabit_per_second: str

        :param acceptable_downtime:
            The value to assign to the acceptable_downtime property of this UpdateAssessmentDetails.
            Allowed values for this property are: "LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS"
        :type acceptable_downtime: str

        :param database_data_size:
            The value to assign to the database_data_size property of this UpdateAssessmentDetails.
            Allowed values for this property are: "LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB"
        :type database_data_size: str

        :param ddl_expectation:
            The value to assign to the ddl_expectation property of this UpdateAssessmentDetails.
            Allowed values for this property are: "DDL_EXPECTED", "DDL_NOT_EXPECTED"
        :type ddl_expectation: str

        :param creation_type:
            The value to assign to the creation_type property of this UpdateAssessmentDetails.
            Allowed values for this property are: "CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS"
        :type creation_type: str

        :param source_database_connection:
            The value to assign to the source_database_connection property of this UpdateAssessmentDetails.
        :type source_database_connection: oci.database_migration.models.SourceAssessmentConnection

        :param target_database_connection:
            The value to assign to the target_database_connection property of this UpdateAssessmentDetails.
        :type target_database_connection: oci.database_migration.models.TargetAssessmentConnection

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAssessmentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAssessmentDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'database_combination': 'str',
            'display_name': 'str',
            'network_speed_megabit_per_second': 'str',
            'acceptable_downtime': 'str',
            'database_data_size': 'str',
            'ddl_expectation': 'str',
            'creation_type': 'str',
            'source_database_connection': 'SourceAssessmentConnection',
            'target_database_connection': 'TargetAssessmentConnection',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'description': 'description',
            'database_combination': 'databaseCombination',
            'display_name': 'displayName',
            'network_speed_megabit_per_second': 'networkSpeedMegabitPerSecond',
            'acceptable_downtime': 'acceptableDowntime',
            'database_data_size': 'databaseDataSize',
            'ddl_expectation': 'ddlExpectation',
            'creation_type': 'creationType',
            'source_database_connection': 'sourceDatabaseConnection',
            'target_database_connection': 'targetDatabaseConnection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._description = None
        self._database_combination = None
        self._display_name = None
        self._network_speed_megabit_per_second = None
        self._acceptable_downtime = None
        self._database_data_size = None
        self._ddl_expectation = None
        self._creation_type = None
        self._source_database_connection = None
        self._target_database_connection = None
        self._freeform_tags = None
        self._defined_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['databaseCombination']

        if type == 'MYSQL':
            return 'UpdateMySqlAssessmentDetails'

        if type == 'ORACLE':
            return 'UpdateOracleAssessmentDetails'
        else:
            return 'UpdateAssessmentDetails'

    @property
    def description(self):
        """
        Gets the description of this UpdateAssessmentDetails.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateAssessmentDetails.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this UpdateAssessmentDetails.
        :type: str
        """
        self._description = description

    @property
    def database_combination(self):
        """
        **[Required]** Gets the database_combination of this UpdateAssessmentDetails.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.

        Allowed values for this property are: "MYSQL", "ORACLE"


        :return: The database_combination of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._database_combination

    @database_combination.setter
    def database_combination(self, database_combination):
        """
        Sets the database_combination of this UpdateAssessmentDetails.
        The combination of source and target databases participating in a migration.
        Example: ORACLE means the migration is meant for migrating Oracle source and target databases.


        :param database_combination: The database_combination of this UpdateAssessmentDetails.
        :type: str
        """
        allowed_values = ["MYSQL", "ORACLE"]
        if not value_allowed_none_or_none_sentinel(database_combination, allowed_values):
            raise ValueError(
                f"Invalid value for `database_combination`, must be None or one of {allowed_values}"
            )
        self._database_combination = database_combination

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateAssessmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateAssessmentDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UpdateAssessmentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def network_speed_megabit_per_second(self):
        """
        Gets the network_speed_megabit_per_second of this UpdateAssessmentDetails.
        A network speed in Megabits per second.

        Allowed values for this property are: "MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000"


        :return: The network_speed_megabit_per_second of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._network_speed_megabit_per_second

    @network_speed_megabit_per_second.setter
    def network_speed_megabit_per_second(self, network_speed_megabit_per_second):
        """
        Sets the network_speed_megabit_per_second of this UpdateAssessmentDetails.
        A network speed in Megabits per second.


        :param network_speed_megabit_per_second: The network_speed_megabit_per_second of this UpdateAssessmentDetails.
        :type: str
        """
        allowed_values = ["MBPS_10", "MBPS_100", "MBPS_1000", "MBPS_2500", "MBPS_5000", "MBPS_10000"]
        if not value_allowed_none_or_none_sentinel(network_speed_megabit_per_second, allowed_values):
            raise ValueError(
                f"Invalid value for `network_speed_megabit_per_second`, must be None or one of {allowed_values}"
            )
        self._network_speed_megabit_per_second = network_speed_megabit_per_second

    @property
    def acceptable_downtime(self):
        """
        Gets the acceptable_downtime of this UpdateAssessmentDetails.
        Time allowed for the application downtime.

        Allowed values for this property are: "LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS"


        :return: The acceptable_downtime of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._acceptable_downtime

    @acceptable_downtime.setter
    def acceptable_downtime(self, acceptable_downtime):
        """
        Sets the acceptable_downtime of this UpdateAssessmentDetails.
        Time allowed for the application downtime.


        :param acceptable_downtime: The acceptable_downtime of this UpdateAssessmentDetails.
        :type: str
        """
        allowed_values = ["LESS_THAN_10_MINUTES", "LESS_THAN_1_HOUR", "LESS_THAN_4_HOURS", "LESS_THAN_8_HOURS", "LESS_THAN_12_HOURS", "LESS_THAN_1_DAY", "LESS_THAN_2_DAYS", "MORE_THAN_2_DAYS"]
        if not value_allowed_none_or_none_sentinel(acceptable_downtime, allowed_values):
            raise ValueError(
                f"Invalid value for `acceptable_downtime`, must be None or one of {allowed_values}"
            )
        self._acceptable_downtime = acceptable_downtime

    @property
    def database_data_size(self):
        """
        Gets the database_data_size of this UpdateAssessmentDetails.
        The size of a source database.

        Allowed values for this property are: "LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB"


        :return: The database_data_size of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._database_data_size

    @database_data_size.setter
    def database_data_size(self, database_data_size):
        """
        Sets the database_data_size of this UpdateAssessmentDetails.
        The size of a source database.


        :param database_data_size: The database_data_size of this UpdateAssessmentDetails.
        :type: str
        """
        allowed_values = ["LESS_THAN_1GB", "GB_1_10", "GB_10_50", "GB_50_100", "GB_100_500", "GB_500_TB_1", "TB_1_3", "TB_3_10", "TB_10_50", "GREATER_THAN_50TB"]
        if not value_allowed_none_or_none_sentinel(database_data_size, allowed_values):
            raise ValueError(
                f"Invalid value for `database_data_size`, must be None or one of {allowed_values}"
            )
        self._database_data_size = database_data_size

    @property
    def ddl_expectation(self):
        """
        Gets the ddl_expectation of this UpdateAssessmentDetails.
        DDL expectation values.

        Allowed values for this property are: "DDL_EXPECTED", "DDL_NOT_EXPECTED"


        :return: The ddl_expectation of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._ddl_expectation

    @ddl_expectation.setter
    def ddl_expectation(self, ddl_expectation):
        """
        Sets the ddl_expectation of this UpdateAssessmentDetails.
        DDL expectation values.


        :param ddl_expectation: The ddl_expectation of this UpdateAssessmentDetails.
        :type: str
        """
        allowed_values = ["DDL_EXPECTED", "DDL_NOT_EXPECTED"]
        if not value_allowed_none_or_none_sentinel(ddl_expectation, allowed_values):
            raise ValueError(
                f"Invalid value for `ddl_expectation`, must be None or one of {allowed_values}"
            )
        self._ddl_expectation = ddl_expectation

    @property
    def creation_type(self):
        """
        Gets the creation_type of this UpdateAssessmentDetails.
        The type of assessment creation.

        Allowed values for this property are: "CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS"


        :return: The creation_type of this UpdateAssessmentDetails.
        :rtype: str
        """
        return self._creation_type

    @creation_type.setter
    def creation_type(self, creation_type):
        """
        Sets the creation_type of this UpdateAssessmentDetails.
        The type of assessment creation.


        :param creation_type: The creation_type of this UpdateAssessmentDetails.
        :type: str
        """
        allowed_values = ["CREATE_ONLY", "CREATE_AND_RUN_ASSESSORS"]
        if not value_allowed_none_or_none_sentinel(creation_type, allowed_values):
            raise ValueError(
                f"Invalid value for `creation_type`, must be None or one of {allowed_values}"
            )
        self._creation_type = creation_type

    @property
    def source_database_connection(self):
        """
        Gets the source_database_connection of this UpdateAssessmentDetails.

        :return: The source_database_connection of this UpdateAssessmentDetails.
        :rtype: oci.database_migration.models.SourceAssessmentConnection
        """
        return self._source_database_connection

    @source_database_connection.setter
    def source_database_connection(self, source_database_connection):
        """
        Sets the source_database_connection of this UpdateAssessmentDetails.

        :param source_database_connection: The source_database_connection of this UpdateAssessmentDetails.
        :type: oci.database_migration.models.SourceAssessmentConnection
        """
        self._source_database_connection = source_database_connection

    @property
    def target_database_connection(self):
        """
        Gets the target_database_connection of this UpdateAssessmentDetails.

        :return: The target_database_connection of this UpdateAssessmentDetails.
        :rtype: oci.database_migration.models.TargetAssessmentConnection
        """
        return self._target_database_connection

    @target_database_connection.setter
    def target_database_connection(self, target_database_connection):
        """
        Sets the target_database_connection of this UpdateAssessmentDetails.

        :param target_database_connection: The target_database_connection of this UpdateAssessmentDetails.
        :type: oci.database_migration.models.TargetAssessmentConnection
        """
        self._target_database_connection = target_database_connection

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAssessmentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :return: The freeform_tags of this UpdateAssessmentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAssessmentDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see Resource Tags. Example: {\"Department\": \"Finance\"}


        :param freeform_tags: The freeform_tags of this UpdateAssessmentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAssessmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateAssessmentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAssessmentDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateAssessmentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
