# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UserDefinedProperty(object):
    """
    User Defined Property
    """

    #: A constant which can be used with the type property of a UserDefinedProperty.
    #: This constant has a value of "TEXT"
    TYPE_TEXT = "TEXT"

    #: A constant which can be used with the type property of a UserDefinedProperty.
    #: This constant has a value of "PASSWORD"
    TYPE_PASSWORD = "PASSWORD"

    #: A constant which can be used with the type property of a UserDefinedProperty.
    #: This constant has a value of "RADIO"
    TYPE_RADIO = "RADIO"

    def __init__(self, **kwargs):
        """
        Initializes a new UserDefinedProperty object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UserDefinedProperty.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this UserDefinedProperty.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UserDefinedProperty.
        :type description: str

        :param type:
            The value to assign to the type property of this UserDefinedProperty.
            Allowed values for this property are: "TEXT", "PASSWORD", "RADIO", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param is_required:
            The value to assign to the is_required property of this UserDefinedProperty.
        :type is_required: bool

        :param min_length:
            The value to assign to the min_length property of this UserDefinedProperty.
        :type min_length: int

        :param max_length:
            The value to assign to the max_length property of this UserDefinedProperty.
        :type max_length: int

        :param default_value:
            The value to assign to the default_value property of this UserDefinedProperty.
        :type default_value: str

        :param value:
            The value to assign to the value property of this UserDefinedProperty.
        :type value: str

        :param options:
            The value to assign to the options property of this UserDefinedProperty.
        :type options: list[oci.database_migration.models.UserDefinedPropertyOption]

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'description': 'str',
            'type': 'str',
            'is_required': 'bool',
            'min_length': 'int',
            'max_length': 'int',
            'default_value': 'str',
            'value': 'str',
            'options': 'list[UserDefinedPropertyOption]'
        }
        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'description': 'description',
            'type': 'type',
            'is_required': 'isRequired',
            'min_length': 'minLength',
            'max_length': 'maxLength',
            'default_value': 'defaultValue',
            'value': 'value',
            'options': 'options'
        }
        self._name = None
        self._display_name = None
        self._description = None
        self._type = None
        self._is_required = None
        self._min_length = None
        self._max_length = None
        self._default_value = None
        self._value = None
        self._options = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this UserDefinedProperty.
        The property name.


        :return: The name of this UserDefinedProperty.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UserDefinedProperty.
        The property name.


        :param name: The name of this UserDefinedProperty.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this UserDefinedProperty.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this UserDefinedProperty.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UserDefinedProperty.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UserDefinedProperty.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UserDefinedProperty.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The description of this UserDefinedProperty.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UserDefinedProperty.
        A user-friendly description. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param description: The description of this UserDefinedProperty.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        **[Required]** Gets the type of this UserDefinedProperty.
        The type of the user defined property.

        Allowed values for this property are: "TEXT", "PASSWORD", "RADIO", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this UserDefinedProperty.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this UserDefinedProperty.
        The type of the user defined property.


        :param type: The type of this UserDefinedProperty.
        :type: str
        """
        allowed_values = ["TEXT", "PASSWORD", "RADIO"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def is_required(self):
        """
        Gets the is_required of this UserDefinedProperty.
        True if the property is required, false otherwise


        :return: The is_required of this UserDefinedProperty.
        :rtype: bool
        """
        return self._is_required

    @is_required.setter
    def is_required(self, is_required):
        """
        Sets the is_required of this UserDefinedProperty.
        True if the property is required, false otherwise


        :param is_required: The is_required of this UserDefinedProperty.
        :type: bool
        """
        self._is_required = is_required

    @property
    def min_length(self):
        """
        Gets the min_length of this UserDefinedProperty.
        Minimum length of the text


        :return: The min_length of this UserDefinedProperty.
        :rtype: int
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length):
        """
        Sets the min_length of this UserDefinedProperty.
        Minimum length of the text


        :param min_length: The min_length of this UserDefinedProperty.
        :type: int
        """
        self._min_length = min_length

    @property
    def max_length(self):
        """
        Gets the max_length of this UserDefinedProperty.
        Maximum length of the text


        :return: The max_length of this UserDefinedProperty.
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """
        Sets the max_length of this UserDefinedProperty.
        Maximum length of the text


        :param max_length: The max_length of this UserDefinedProperty.
        :type: int
        """
        self._max_length = max_length

    @property
    def default_value(self):
        """
        Gets the default_value of this UserDefinedProperty.
        The default value of the property.


        :return: The default_value of this UserDefinedProperty.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this UserDefinedProperty.
        The default value of the property.


        :param default_value: The default_value of this UserDefinedProperty.
        :type: str
        """
        self._default_value = default_value

    @property
    def value(self):
        """
        Gets the value of this UserDefinedProperty.
        The value of the property.


        :return: The value of this UserDefinedProperty.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this UserDefinedProperty.
        The value of the property.


        :param value: The value of this UserDefinedProperty.
        :type: str
        """
        self._value = value

    @property
    def options(self):
        """
        Gets the options of this UserDefinedProperty.
        User defined property options.


        :return: The options of this UserDefinedProperty.
        :rtype: list[oci.database_migration.models.UserDefinedPropertyOption]
        """
        return self._options

    @options.setter
    def options(self, options):
        """
        Sets the options of this UserDefinedProperty.
        User defined property options.


        :param options: The options of this UserDefinedProperty.
        :type: list[oci.database_migration.models.UserDefinedPropertyOption]
        """
        self._options = options

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
