# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005

from .database_tools_connection_oracle_database_proxy_client import DatabaseToolsConnectionOracleDatabaseProxyClient
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseToolsConnectionOracleDatabaseProxyClientNoProxy(DatabaseToolsConnectionOracleDatabaseProxyClient):
    """
    Represents blank proxy client information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseToolsConnectionOracleDatabaseProxyClientNoProxy object with values from keyword arguments. The default value of the :py:attr:`~oci.database_tools.models.DatabaseToolsConnectionOracleDatabaseProxyClientNoProxy.proxy_authentication_type` attribute
        of this class is ``NO_PROXY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param proxy_authentication_type:
            The value to assign to the proxy_authentication_type property of this DatabaseToolsConnectionOracleDatabaseProxyClientNoProxy.
            Allowed values for this property are: "USER_NAME", "NO_PROXY"
        :type proxy_authentication_type: str

        """
        self.swagger_types = {
            'proxy_authentication_type': 'str'
        }
        self.attribute_map = {
            'proxy_authentication_type': 'proxyAuthenticationType'
        }
        self._proxy_authentication_type = None
        self._proxy_authentication_type = 'NO_PROXY'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
