# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchActivityDetails(object):
    """
    Details of deploy, update and migrate-listener(only for single Instance database) operations for this resource.
    """

    #: A constant which can be used with the deploy_status property of a PatchActivityDetails.
    #: This constant has a value of "SCHEDULED"
    DEPLOY_STATUS_SCHEDULED = "SCHEDULED"

    #: A constant which can be used with the deploy_status property of a PatchActivityDetails.
    #: This constant has a value of "RUNNING"
    DEPLOY_STATUS_RUNNING = "RUNNING"

    #: A constant which can be used with the deploy_status property of a PatchActivityDetails.
    #: This constant has a value of "COMPLETED"
    DEPLOY_STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the deploy_status property of a PatchActivityDetails.
    #: This constant has a value of "FAILED"
    DEPLOY_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the update_status property of a PatchActivityDetails.
    #: This constant has a value of "SCHEDULED"
    UPDATE_STATUS_SCHEDULED = "SCHEDULED"

    #: A constant which can be used with the update_status property of a PatchActivityDetails.
    #: This constant has a value of "RUNNING"
    UPDATE_STATUS_RUNNING = "RUNNING"

    #: A constant which can be used with the update_status property of a PatchActivityDetails.
    #: This constant has a value of "COMPLETED"
    UPDATE_STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the update_status property of a PatchActivityDetails.
    #: This constant has a value of "FAILED"
    UPDATE_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the migrate_listener_status property of a PatchActivityDetails.
    #: This constant has a value of "SCHEDULED"
    MIGRATE_LISTENER_STATUS_SCHEDULED = "SCHEDULED"

    #: A constant which can be used with the migrate_listener_status property of a PatchActivityDetails.
    #: This constant has a value of "RUNNING"
    MIGRATE_LISTENER_STATUS_RUNNING = "RUNNING"

    #: A constant which can be used with the migrate_listener_status property of a PatchActivityDetails.
    #: This constant has a value of "COMPLETED"
    MIGRATE_LISTENER_STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the migrate_listener_status property of a PatchActivityDetails.
    #: This constant has a value of "FAILED"
    MIGRATE_LISTENER_STATUS_FAILED = "FAILED"

    #: A constant which can be used with the migrate_listener_status property of a PatchActivityDetails.
    #: This constant has a value of "NA"
    MIGRATE_LISTENER_STATUS_NA = "NA"

    def __init__(self, **kwargs):
        """
        Initializes a new PatchActivityDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param deploy_operation_id:
            The value to assign to the deploy_operation_id property of this PatchActivityDetails.
        :type deploy_operation_id: str

        :param deploy_task_id:
            The value to assign to the deploy_task_id property of this PatchActivityDetails.
        :type deploy_task_id: str

        :param deploy_status:
            The value to assign to the deploy_status property of this PatchActivityDetails.
            Allowed values for this property are: "SCHEDULED", "RUNNING", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deploy_status: str

        :param update_operation_id:
            The value to assign to the update_operation_id property of this PatchActivityDetails.
        :type update_operation_id: str

        :param update_task_id:
            The value to assign to the update_task_id property of this PatchActivityDetails.
        :type update_task_id: str

        :param update_status:
            The value to assign to the update_status property of this PatchActivityDetails.
            Allowed values for this property are: "SCHEDULED", "RUNNING", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type update_status: str

        :param migrate_listener_operation_id:
            The value to assign to the migrate_listener_operation_id property of this PatchActivityDetails.
        :type migrate_listener_operation_id: str

        :param migrate_listener_task_id:
            The value to assign to the migrate_listener_task_id property of this PatchActivityDetails.
        :type migrate_listener_task_id: str

        :param migrate_listener_status:
            The value to assign to the migrate_listener_status property of this PatchActivityDetails.
            Allowed values for this property are: "SCHEDULED", "RUNNING", "COMPLETED", "FAILED", "NA", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type migrate_listener_status: str

        """
        self.swagger_types = {
            'deploy_operation_id': 'str',
            'deploy_task_id': 'str',
            'deploy_status': 'str',
            'update_operation_id': 'str',
            'update_task_id': 'str',
            'update_status': 'str',
            'migrate_listener_operation_id': 'str',
            'migrate_listener_task_id': 'str',
            'migrate_listener_status': 'str'
        }
        self.attribute_map = {
            'deploy_operation_id': 'deployOperationId',
            'deploy_task_id': 'deployTaskId',
            'deploy_status': 'deployStatus',
            'update_operation_id': 'updateOperationId',
            'update_task_id': 'updateTaskId',
            'update_status': 'updateStatus',
            'migrate_listener_operation_id': 'migrateListenerOperationId',
            'migrate_listener_task_id': 'migrateListenerTaskId',
            'migrate_listener_status': 'migrateListenerStatus'
        }
        self._deploy_operation_id = None
        self._deploy_task_id = None
        self._deploy_status = None
        self._update_operation_id = None
        self._update_task_id = None
        self._update_status = None
        self._migrate_listener_operation_id = None
        self._migrate_listener_task_id = None
        self._migrate_listener_status = None

    @property
    def deploy_operation_id(self):
        """
        Gets the deploy_operation_id of this PatchActivityDetails.
        Operation Identifier for deploy operation.


        :return: The deploy_operation_id of this PatchActivityDetails.
        :rtype: str
        """
        return self._deploy_operation_id

    @deploy_operation_id.setter
    def deploy_operation_id(self, deploy_operation_id):
        """
        Sets the deploy_operation_id of this PatchActivityDetails.
        Operation Identifier for deploy operation.


        :param deploy_operation_id: The deploy_operation_id of this PatchActivityDetails.
        :type: str
        """
        self._deploy_operation_id = deploy_operation_id

    @property
    def deploy_task_id(self):
        """
        Gets the deploy_task_id of this PatchActivityDetails.
        Task identifier for deploy operation.


        :return: The deploy_task_id of this PatchActivityDetails.
        :rtype: str
        """
        return self._deploy_task_id

    @deploy_task_id.setter
    def deploy_task_id(self, deploy_task_id):
        """
        Sets the deploy_task_id of this PatchActivityDetails.
        Task identifier for deploy operation.


        :param deploy_task_id: The deploy_task_id of this PatchActivityDetails.
        :type: str
        """
        self._deploy_task_id = deploy_task_id

    @property
    def deploy_status(self):
        """
        Gets the deploy_status of this PatchActivityDetails.
        Status of deploy operation.

        Allowed values for this property are: "SCHEDULED", "RUNNING", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deploy_status of this PatchActivityDetails.
        :rtype: str
        """
        return self._deploy_status

    @deploy_status.setter
    def deploy_status(self, deploy_status):
        """
        Sets the deploy_status of this PatchActivityDetails.
        Status of deploy operation.


        :param deploy_status: The deploy_status of this PatchActivityDetails.
        :type: str
        """
        allowed_values = ["SCHEDULED", "RUNNING", "COMPLETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(deploy_status, allowed_values):
            deploy_status = 'UNKNOWN_ENUM_VALUE'
        self._deploy_status = deploy_status

    @property
    def update_operation_id(self):
        """
        Gets the update_operation_id of this PatchActivityDetails.
        Operation Identifier for update operation.


        :return: The update_operation_id of this PatchActivityDetails.
        :rtype: str
        """
        return self._update_operation_id

    @update_operation_id.setter
    def update_operation_id(self, update_operation_id):
        """
        Sets the update_operation_id of this PatchActivityDetails.
        Operation Identifier for update operation.


        :param update_operation_id: The update_operation_id of this PatchActivityDetails.
        :type: str
        """
        self._update_operation_id = update_operation_id

    @property
    def update_task_id(self):
        """
        Gets the update_task_id of this PatchActivityDetails.
        Task identifier for update operation.


        :return: The update_task_id of this PatchActivityDetails.
        :rtype: str
        """
        return self._update_task_id

    @update_task_id.setter
    def update_task_id(self, update_task_id):
        """
        Sets the update_task_id of this PatchActivityDetails.
        Task identifier for update operation.


        :param update_task_id: The update_task_id of this PatchActivityDetails.
        :type: str
        """
        self._update_task_id = update_task_id

    @property
    def update_status(self):
        """
        Gets the update_status of this PatchActivityDetails.
        Status of update operation.

        Allowed values for this property are: "SCHEDULED", "RUNNING", "COMPLETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The update_status of this PatchActivityDetails.
        :rtype: str
        """
        return self._update_status

    @update_status.setter
    def update_status(self, update_status):
        """
        Sets the update_status of this PatchActivityDetails.
        Status of update operation.


        :param update_status: The update_status of this PatchActivityDetails.
        :type: str
        """
        allowed_values = ["SCHEDULED", "RUNNING", "COMPLETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(update_status, allowed_values):
            update_status = 'UNKNOWN_ENUM_VALUE'
        self._update_status = update_status

    @property
    def migrate_listener_operation_id(self):
        """
        Gets the migrate_listener_operation_id of this PatchActivityDetails.
        Operation Identifier for migrate listener operation.


        :return: The migrate_listener_operation_id of this PatchActivityDetails.
        :rtype: str
        """
        return self._migrate_listener_operation_id

    @migrate_listener_operation_id.setter
    def migrate_listener_operation_id(self, migrate_listener_operation_id):
        """
        Sets the migrate_listener_operation_id of this PatchActivityDetails.
        Operation Identifier for migrate listener operation.


        :param migrate_listener_operation_id: The migrate_listener_operation_id of this PatchActivityDetails.
        :type: str
        """
        self._migrate_listener_operation_id = migrate_listener_operation_id

    @property
    def migrate_listener_task_id(self):
        """
        Gets the migrate_listener_task_id of this PatchActivityDetails.
        Task identifier for migrate listener operation.


        :return: The migrate_listener_task_id of this PatchActivityDetails.
        :rtype: str
        """
        return self._migrate_listener_task_id

    @migrate_listener_task_id.setter
    def migrate_listener_task_id(self, migrate_listener_task_id):
        """
        Sets the migrate_listener_task_id of this PatchActivityDetails.
        Task identifier for migrate listener operation.


        :param migrate_listener_task_id: The migrate_listener_task_id of this PatchActivityDetails.
        :type: str
        """
        self._migrate_listener_task_id = migrate_listener_task_id

    @property
    def migrate_listener_status(self):
        """
        Gets the migrate_listener_status of this PatchActivityDetails.
        Status of migrate listener operation.

        Allowed values for this property are: "SCHEDULED", "RUNNING", "COMPLETED", "FAILED", "NA", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The migrate_listener_status of this PatchActivityDetails.
        :rtype: str
        """
        return self._migrate_listener_status

    @migrate_listener_status.setter
    def migrate_listener_status(self, migrate_listener_status):
        """
        Sets the migrate_listener_status of this PatchActivityDetails.
        Status of migrate listener operation.


        :param migrate_listener_status: The migrate_listener_status of this PatchActivityDetails.
        :type: str
        """
        allowed_values = ["SCHEDULED", "RUNNING", "COMPLETED", "FAILED", "NA"]
        if not value_allowed_none_or_none_sentinel(migrate_listener_status, allowed_values):
            migrate_listener_status = 'UNKNOWN_ENUM_VALUE'
        self._migrate_listener_status = migrate_listener_status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
