# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleDbGcpKeyRing(object):
    """
    Oracle DB GCP Key Ring resource object.
    """

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpKeyRing.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpKeyRing.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpKeyRing.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpKeyRing.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpKeyRing.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a OracleDbGcpKeyRing.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new OracleDbGcpKeyRing object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleDbGcpKeyRing.
        :type id: str

        :param oracle_db_connector_id:
            The value to assign to the oracle_db_connector_id property of this OracleDbGcpKeyRing.
        :type oracle_db_connector_id: str

        :param display_name:
            The value to assign to the display_name property of this OracleDbGcpKeyRing.
        :type display_name: str

        :param gcp_key_ring_id:
            The value to assign to the gcp_key_ring_id property of this OracleDbGcpKeyRing.
        :type gcp_key_ring_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleDbGcpKeyRing.
        :type compartment_id: str

        :param type:
            The value to assign to the type property of this OracleDbGcpKeyRing.
        :type type: str

        :param location:
            The value to assign to the location property of this OracleDbGcpKeyRing.
        :type location: str

        :param properties:
            The value to assign to the properties property of this OracleDbGcpKeyRing.
        :type properties: dict(str, str)

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleDbGcpKeyRing.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this OracleDbGcpKeyRing.
        :type lifecycle_state_details: str

        :param time_created:
            The value to assign to the time_created property of this OracleDbGcpKeyRing.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleDbGcpKeyRing.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleDbGcpKeyRing.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleDbGcpKeyRing.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleDbGcpKeyRing.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'oracle_db_connector_id': 'str',
            'display_name': 'str',
            'gcp_key_ring_id': 'str',
            'compartment_id': 'str',
            'type': 'str',
            'location': 'str',
            'properties': 'dict(str, str)',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'oracle_db_connector_id': 'oracleDbConnectorId',
            'display_name': 'displayName',
            'gcp_key_ring_id': 'gcpKeyRingId',
            'compartment_id': 'compartmentId',
            'type': 'type',
            'location': 'location',
            'properties': 'properties',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._oracle_db_connector_id = None
        self._display_name = None
        self._gcp_key_ring_id = None
        self._compartment_id = None
        self._type = None
        self._location = None
        self._properties = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OracleDbGcpKeyRing.
        The `OCID`__ of the DB GCP Key Ring resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OracleDbGcpKeyRing.
        The `OCID`__ of the DB GCP Key Ring resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this OracleDbGcpKeyRing.
        :type: str
        """
        self._id = id

    @property
    def oracle_db_connector_id(self):
        """
        Gets the oracle_db_connector_id of this OracleDbGcpKeyRing.
        The `OCID`__ of the compartment where the Oracle DB GCP Identity Connector resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_connector_id of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._oracle_db_connector_id

    @oracle_db_connector_id.setter
    def oracle_db_connector_id(self, oracle_db_connector_id):
        """
        Sets the oracle_db_connector_id of this OracleDbGcpKeyRing.
        The `OCID`__ of the compartment where the Oracle DB GCP Identity Connector resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_connector_id: The oracle_db_connector_id of this OracleDbGcpKeyRing.
        :type: str
        """
        self._oracle_db_connector_id = oracle_db_connector_id

    @property
    def display_name(self):
        """
        Gets the display_name of this OracleDbGcpKeyRing.
        Display name of DB GCP Key Ring resource.


        :return: The display_name of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OracleDbGcpKeyRing.
        Display name of DB GCP Key Ring resource.


        :param display_name: The display_name of this OracleDbGcpKeyRing.
        :type: str
        """
        self._display_name = display_name

    @property
    def gcp_key_ring_id(self):
        """
        Gets the gcp_key_ring_id of this OracleDbGcpKeyRing.
        GCP Key Ring ID.


        :return: The gcp_key_ring_id of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._gcp_key_ring_id

    @gcp_key_ring_id.setter
    def gcp_key_ring_id(self, gcp_key_ring_id):
        """
        Sets the gcp_key_ring_id of this OracleDbGcpKeyRing.
        GCP Key Ring ID.


        :param gcp_key_ring_id: The gcp_key_ring_id of this OracleDbGcpKeyRing.
        :type: str
        """
        self._gcp_key_ring_id = gcp_key_ring_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OracleDbGcpKeyRing.
        The compartment `OCID`__ where the Oracle DB GCP Key Ring resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OracleDbGcpKeyRing.
        The compartment `OCID`__ where the Oracle DB GCP Key Ring resource resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this OracleDbGcpKeyRing.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def type(self):
        """
        Gets the type of this OracleDbGcpKeyRing.
        Oracle DB GCP Key Ring resource Type.


        :return: The type of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this OracleDbGcpKeyRing.
        Oracle DB GCP Key Ring resource Type.


        :param type: The type of this OracleDbGcpKeyRing.
        :type: str
        """
        self._type = type

    @property
    def location(self):
        """
        Gets the location of this OracleDbGcpKeyRing.
        Location of the GCP Key Ring resource.


        :return: The location of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this OracleDbGcpKeyRing.
        Location of the GCP Key Ring resource.


        :param location: The location of this OracleDbGcpKeyRing.
        :type: str
        """
        self._location = location

    @property
    def properties(self):
        """
        Gets the properties of this OracleDbGcpKeyRing.
        Oracle DB GCP Key Ring resource's properties.


        :return: The properties of this OracleDbGcpKeyRing.
        :rtype: dict(str, str)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this OracleDbGcpKeyRing.
        Oracle DB GCP Key Ring resource's properties.


        :param properties: The properties of this OracleDbGcpKeyRing.
        :type: dict(str, str)
        """
        self._properties = properties

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OracleDbGcpKeyRing.
        The lifecycle state of the Oracle DB GCP Key Ring resource.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OracleDbGcpKeyRing.
        The lifecycle state of the Oracle DB GCP Key Ring resource.


        :param lifecycle_state: The lifecycle_state of this OracleDbGcpKeyRing.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this OracleDbGcpKeyRing.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this OracleDbGcpKeyRing.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this OracleDbGcpKeyRing.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this OracleDbGcpKeyRing.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def time_created(self):
        """
        Gets the time_created of this OracleDbGcpKeyRing.
        Time when the DB GCP Key Ring resource was created in `RFC 3339`__ timestamp format, e.g. '2020-05-23T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this OracleDbGcpKeyRing.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OracleDbGcpKeyRing.
        Time when the DB GCP Key Ring resource was created in `RFC 3339`__ timestamp format, e.g. '2020-05-23T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this OracleDbGcpKeyRing.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OracleDbGcpKeyRing.
        Time when the DB GCP Key Ring resource was last modified, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-23T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this OracleDbGcpKeyRing.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OracleDbGcpKeyRing.
        Time when the DB GCP Key Ring resource was last modified, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-23T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this OracleDbGcpKeyRing.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OracleDbGcpKeyRing.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this OracleDbGcpKeyRing.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OracleDbGcpKeyRing.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this OracleDbGcpKeyRing.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OracleDbGcpKeyRing.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this OracleDbGcpKeyRing.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OracleDbGcpKeyRing.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this OracleDbGcpKeyRing.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OracleDbGcpKeyRing.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OracleDbGcpKeyRing.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OracleDbGcpKeyRing.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OracleDbGcpKeyRing.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
