# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .repository_ref_summary import RepositoryRefSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RepositoryBranchSummary(RepositoryRefSummary):
    """
    Branch related information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RepositoryBranchSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.RepositoryBranchSummary.ref_type` attribute
        of this class is ``BRANCH`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ref_name:
            The value to assign to the ref_name property of this RepositoryBranchSummary.
        :type ref_name: str

        :param ref_type:
            The value to assign to the ref_type property of this RepositoryBranchSummary.
        :type ref_type: str

        :param full_ref_name:
            The value to assign to the full_ref_name property of this RepositoryBranchSummary.
        :type full_ref_name: str

        :param repository_id:
            The value to assign to the repository_id property of this RepositoryBranchSummary.
        :type repository_id: str

        :param time_created:
            The value to assign to the time_created property of this RepositoryBranchSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this RepositoryBranchSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this RepositoryBranchSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this RepositoryBranchSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this RepositoryBranchSummary.
        :type system_tags: dict(str, dict(str, object))

        :param commit_id:
            The value to assign to the commit_id property of this RepositoryBranchSummary.
        :type commit_id: str

        :param latest_commit_author_name:
            The value to assign to the latest_commit_author_name property of this RepositoryBranchSummary.
        :type latest_commit_author_name: str

        :param top_n_pull_requests:
            The value to assign to the top_n_pull_requests property of this RepositoryBranchSummary.
        :type top_n_pull_requests: list[oci.devops.models.PullRequestSummary]

        :param pull_request_state_counts:
            The value to assign to the pull_request_state_counts property of this RepositoryBranchSummary.
        :type pull_request_state_counts: dict(str, int)

        """
        self.swagger_types = {
            'ref_name': 'str',
            'ref_type': 'str',
            'full_ref_name': 'str',
            'repository_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'commit_id': 'str',
            'latest_commit_author_name': 'str',
            'top_n_pull_requests': 'list[PullRequestSummary]',
            'pull_request_state_counts': 'dict(str, int)'
        }
        self.attribute_map = {
            'ref_name': 'refName',
            'ref_type': 'refType',
            'full_ref_name': 'fullRefName',
            'repository_id': 'repositoryId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'commit_id': 'commitId',
            'latest_commit_author_name': 'latestCommitAuthorName',
            'top_n_pull_requests': 'topNPullRequests',
            'pull_request_state_counts': 'pullRequestStateCounts'
        }
        self._ref_name = None
        self._ref_type = None
        self._full_ref_name = None
        self._repository_id = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._commit_id = None
        self._latest_commit_author_name = None
        self._top_n_pull_requests = None
        self._pull_request_state_counts = None
        self._ref_type = 'BRANCH'

    @property
    def commit_id(self):
        """
        **[Required]** Gets the commit_id of this RepositoryBranchSummary.
        Commit ID pointed to by the new branch.


        :return: The commit_id of this RepositoryBranchSummary.
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id):
        """
        Sets the commit_id of this RepositoryBranchSummary.
        Commit ID pointed to by the new branch.


        :param commit_id: The commit_id of this RepositoryBranchSummary.
        :type: str
        """
        self._commit_id = commit_id

    @property
    def latest_commit_author_name(self):
        """
        Gets the latest_commit_author_name of this RepositoryBranchSummary.
        The author of latest commit


        :return: The latest_commit_author_name of this RepositoryBranchSummary.
        :rtype: str
        """
        return self._latest_commit_author_name

    @latest_commit_author_name.setter
    def latest_commit_author_name(self, latest_commit_author_name):
        """
        Sets the latest_commit_author_name of this RepositoryBranchSummary.
        The author of latest commit


        :param latest_commit_author_name: The latest_commit_author_name of this RepositoryBranchSummary.
        :type: str
        """
        self._latest_commit_author_name = latest_commit_author_name

    @property
    def top_n_pull_requests(self):
        """
        Gets the top_n_pull_requests of this RepositoryBranchSummary.
        Up to 5 pull requests associated with this branch.


        :return: The top_n_pull_requests of this RepositoryBranchSummary.
        :rtype: list[oci.devops.models.PullRequestSummary]
        """
        return self._top_n_pull_requests

    @top_n_pull_requests.setter
    def top_n_pull_requests(self, top_n_pull_requests):
        """
        Sets the top_n_pull_requests of this RepositoryBranchSummary.
        Up to 5 pull requests associated with this branch.


        :param top_n_pull_requests: The top_n_pull_requests of this RepositoryBranchSummary.
        :type: list[oci.devops.models.PullRequestSummary]
        """
        self._top_n_pull_requests = top_n_pull_requests

    @property
    def pull_request_state_counts(self):
        """
        Gets the pull_request_state_counts of this RepositoryBranchSummary.
        Counts of pull requests for this branch grouped by their state.


        :return: The pull_request_state_counts of this RepositoryBranchSummary.
        :rtype: dict(str, int)
        """
        return self._pull_request_state_counts

    @pull_request_state_counts.setter
    def pull_request_state_counts(self, pull_request_state_counts):
        """
        Sets the pull_request_state_counts of this RepositoryBranchSummary.
        Counts of pull requests for this branch grouped by their state.


        :param pull_request_state_counts: The pull_request_state_counts of this RepositoryBranchSummary.
        :type: dict(str, int)
        """
        self._pull_request_state_counts = pull_request_state_counts

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
