# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TriggerDeploymentDryRunDetails(object):
    """
    Details of a new deployment to be created that will run to get helm diff for a helmDiffArgumentCollection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TriggerDeploymentDryRunDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param helm_diff_arguments:
            The value to assign to the helm_diff_arguments property of this TriggerDeploymentDryRunDetails.
        :type helm_diff_arguments: oci.devops.models.HelmDiffArgumentCollection

        :param create_deployment_details:
            The value to assign to the create_deployment_details property of this TriggerDeploymentDryRunDetails.
        :type create_deployment_details: oci.devops.models.CreateDeploymentDetails

        """
        self.swagger_types = {
            'helm_diff_arguments': 'HelmDiffArgumentCollection',
            'create_deployment_details': 'CreateDeploymentDetails'
        }
        self.attribute_map = {
            'helm_diff_arguments': 'helmDiffArguments',
            'create_deployment_details': 'createDeploymentDetails'
        }
        self._helm_diff_arguments = None
        self._create_deployment_details = None

    @property
    def helm_diff_arguments(self):
        """
        **[Required]** Gets the helm_diff_arguments of this TriggerDeploymentDryRunDetails.

        :return: The helm_diff_arguments of this TriggerDeploymentDryRunDetails.
        :rtype: oci.devops.models.HelmDiffArgumentCollection
        """
        return self._helm_diff_arguments

    @helm_diff_arguments.setter
    def helm_diff_arguments(self, helm_diff_arguments):
        """
        Sets the helm_diff_arguments of this TriggerDeploymentDryRunDetails.

        :param helm_diff_arguments: The helm_diff_arguments of this TriggerDeploymentDryRunDetails.
        :type: oci.devops.models.HelmDiffArgumentCollection
        """
        self._helm_diff_arguments = helm_diff_arguments

    @property
    def create_deployment_details(self):
        """
        **[Required]** Gets the create_deployment_details of this TriggerDeploymentDryRunDetails.

        :return: The create_deployment_details of this TriggerDeploymentDryRunDetails.
        :rtype: oci.devops.models.CreateDeploymentDetails
        """
        return self._create_deployment_details

    @create_deployment_details.setter
    def create_deployment_details(self, create_deployment_details):
        """
        Sets the create_deployment_details of this TriggerDeploymentDryRunDetails.

        :param create_deployment_details: The create_deployment_details of this TriggerDeploymentDryRunDetails.
        :type: oci.devops.models.CreateDeploymentDetails
        """
        self._create_deployment_details = create_deployment_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
