# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComponentValueOverride(object):
    """
    Component overrides for stack\u2011specific parameters applied during artifact template rendering.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComponentValueOverride object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_name:
            The value to assign to the component_name property of this ComponentValueOverride.
        :type component_name: str

        :param value_overrides:
            The value to assign to the value_overrides property of this ComponentValueOverride.
        :type value_overrides: dict(str, str)

        """
        self.swagger_types = {
            'component_name': 'str',
            'value_overrides': 'dict(str, str)'
        }
        self.attribute_map = {
            'component_name': 'componentName',
            'value_overrides': 'valueOverrides'
        }
        self._component_name = None
        self._value_overrides = None

    @property
    def component_name(self):
        """
        **[Required]** Gets the component_name of this ComponentValueOverride.
        Logical name of the grouping independently deployable kubernetes resource artifacts for the current deployment.


        :return: The component_name of this ComponentValueOverride.
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name):
        """
        Sets the component_name of this ComponentValueOverride.
        Logical name of the grouping independently deployable kubernetes resource artifacts for the current deployment.


        :param component_name: The component_name of this ComponentValueOverride.
        :type: str
        """
        self._component_name = component_name

    @property
    def value_overrides(self):
        """
        **[Required]** Gets the value_overrides of this ComponentValueOverride.
        Free-form value overrides for the component. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Used for overriding the values in value.yaml artifact of the component.
        Example: `{\"WORKER_THREADS\": \"8\"}`


        :return: The value_overrides of this ComponentValueOverride.
        :rtype: dict(str, str)
        """
        return self._value_overrides

    @value_overrides.setter
    def value_overrides(self, value_overrides):
        """
        Sets the value_overrides of this ComponentValueOverride.
        Free-form value overrides for the component. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        Used for overriding the values in value.yaml artifact of the component.
        Example: `{\"WORKER_THREADS\": \"8\"}`


        :param value_overrides: The value_overrides of this ComponentValueOverride.
        :type: dict(str, str)
        """
        self._value_overrides = value_overrides

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
