# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageDetail(object):
    """
    Object Storage Details required to provision buckets.
    """

    #: A constant which can be used with the object_versioning property of a ObjectStorageDetail.
    #: This constant has a value of "ENABLED"
    OBJECT_VERSIONING_ENABLED = "ENABLED"

    #: A constant which can be used with the object_versioning property of a ObjectStorageDetail.
    #: This constant has a value of "SUSPENDED"
    OBJECT_VERSIONING_SUSPENDED = "SUSPENDED"

    #: A constant which can be used with the object_versioning property of a ObjectStorageDetail.
    #: This constant has a value of "DISABLED"
    OBJECT_VERSIONING_DISABLED = "DISABLED"

    #: A constant which can be used with the storage_tier property of a ObjectStorageDetail.
    #: This constant has a value of "STANDARD"
    STORAGE_TIER_STANDARD = "STANDARD"

    #: A constant which can be used with the storage_tier property of a ObjectStorageDetail.
    #: This constant has a value of "ARCHIVE"
    STORAGE_TIER_ARCHIVE = "ARCHIVE"

    #: A constant which can be used with the auto_tiering property of a ObjectStorageDetail.
    #: This constant has a value of "DISABLED"
    AUTO_TIERING_DISABLED = "DISABLED"

    #: A constant which can be used with the auto_tiering property of a ObjectStorageDetail.
    #: This constant has a value of "INFREQUENTACCESS"
    AUTO_TIERING_INFREQUENTACCESS = "INFREQUENTACCESS"

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this ObjectStorageDetail.
        :type instance_id: str

        :param object_versioning:
            The value to assign to the object_versioning property of this ObjectStorageDetail.
            Allowed values for this property are: "ENABLED", "SUSPENDED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type object_versioning: str

        :param storage_tier:
            The value to assign to the storage_tier property of this ObjectStorageDetail.
            Allowed values for this property are: "STANDARD", "ARCHIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type storage_tier: str

        :param auto_tiering:
            The value to assign to the auto_tiering property of this ObjectStorageDetail.
            Allowed values for this property are: "DISABLED", "INFREQUENTACCESS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type auto_tiering: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'object_versioning': 'str',
            'storage_tier': 'str',
            'auto_tiering': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'object_versioning': 'objectVersioning',
            'storage_tier': 'storageTier',
            'auto_tiering': 'autoTiering'
        }
        self._instance_id = None
        self._object_versioning = None
        self._storage_tier = None
        self._auto_tiering = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this ObjectStorageDetail.
        Id for Object Storage instance to be provisioned.


        :return: The instance_id of this ObjectStorageDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this ObjectStorageDetail.
        Id for Object Storage instance to be provisioned.


        :param instance_id: The instance_id of this ObjectStorageDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def object_versioning(self):
        """
        **[Required]** Gets the object_versioning of this ObjectStorageDetail.
        Mentions whether the object versioning to be enabled or not,Allowed values are \"ENABLED\" / \"DISABLED\"/\"SUSPENDED\"

        Allowed values for this property are: "ENABLED", "SUSPENDED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The object_versioning of this ObjectStorageDetail.
        :rtype: str
        """
        return self._object_versioning

    @object_versioning.setter
    def object_versioning(self, object_versioning):
        """
        Sets the object_versioning of this ObjectStorageDetail.
        Mentions whether the object versioning to be enabled or not,Allowed values are \"ENABLED\" / \"DISABLED\"/\"SUSPENDED\"


        :param object_versioning: The object_versioning of this ObjectStorageDetail.
        :type: str
        """
        allowed_values = ["ENABLED", "SUSPENDED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(object_versioning, allowed_values):
            object_versioning = 'UNKNOWN_ENUM_VALUE'
        self._object_versioning = object_versioning

    @property
    def storage_tier(self):
        """
        **[Required]** Gets the storage_tier of this ObjectStorageDetail.
        Mentions which storage tier to use for the bucket,Allowed values are \"STANDARD\" / \"ARCHIVE\"

        Allowed values for this property are: "STANDARD", "ARCHIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The storage_tier of this ObjectStorageDetail.
        :rtype: str
        """
        return self._storage_tier

    @storage_tier.setter
    def storage_tier(self, storage_tier):
        """
        Sets the storage_tier of this ObjectStorageDetail.
        Mentions which storage tier to use for the bucket,Allowed values are \"STANDARD\" / \"ARCHIVE\"


        :param storage_tier: The storage_tier of this ObjectStorageDetail.
        :type: str
        """
        allowed_values = ["STANDARD", "ARCHIVE"]
        if not value_allowed_none_or_none_sentinel(storage_tier, allowed_values):
            storage_tier = 'UNKNOWN_ENUM_VALUE'
        self._storage_tier = storage_tier

    @property
    def auto_tiering(self):
        """
        Gets the auto_tiering of this ObjectStorageDetail.
        It sets the auto-tiering status on the bucket.Allowed values are \"DISABLED\" / \"INFREQUENTACCESS\"

        Allowed values for this property are: "DISABLED", "INFREQUENTACCESS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The auto_tiering of this ObjectStorageDetail.
        :rtype: str
        """
        return self._auto_tiering

    @auto_tiering.setter
    def auto_tiering(self, auto_tiering):
        """
        Sets the auto_tiering of this ObjectStorageDetail.
        It sets the auto-tiering status on the bucket.Allowed values are \"DISABLED\" / \"INFREQUENTACCESS\"


        :param auto_tiering: The auto_tiering of this ObjectStorageDetail.
        :type: str
        """
        allowed_values = ["DISABLED", "INFREQUENTACCESS"]
        if not value_allowed_none_or_none_sentinel(auto_tiering, allowed_values):
            auto_tiering = 'UNKNOWN_ENUM_VALUE'
        self._auto_tiering = auto_tiering

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
