# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDataflowConnections(object):
    """
    Details for connections to other services from Dataflow.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDataflowConnections object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_details:
            The value to assign to the connection_details property of this UpdateDataflowConnections.
        :type connection_details: oci.dif.models.DataflowConnectionDetails

        """
        self.swagger_types = {
            'connection_details': 'DataflowConnectionDetails'
        }
        self.attribute_map = {
            'connection_details': 'connectionDetails'
        }
        self._connection_details = None

    @property
    def connection_details(self):
        """
        **[Required]** Gets the connection_details of this UpdateDataflowConnections.

        :return: The connection_details of this UpdateDataflowConnections.
        :rtype: oci.dif.models.DataflowConnectionDetails
        """
        return self._connection_details

    @connection_details.setter
    def connection_details(self, connection_details):
        """
        Sets the connection_details of this UpdateDataflowConnections.

        :param connection_details: The connection_details of this UpdateDataflowConnections.
        :type: oci.dif.models.DataflowConnectionDetails
        """
        self._connection_details = connection_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
