# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .create_automatic_dr_configuration_member_details import CreateAutomaticDrConfigurationMemberDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails(CreateAutomaticDrConfigurationMemberDetails):
    """
    Create properties for an Autonomous Container Database member in an Automatic DR configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.disaster_recovery.models.CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.member_type` attribute
        of this class is ``AUTONOMOUS_CONTAINER_DATABASE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_id:
            The value to assign to the member_id property of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        :type member_id: str

        :param member_type:
            The value to assign to the member_type property of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
            Allowed values for this property are: "DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE"
        :type member_type: str

        :param is_auto_switchover_enabled:
            The value to assign to the is_auto_switchover_enabled property of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        :type is_auto_switchover_enabled: bool

        :param is_auto_failover_enabled:
            The value to assign to the is_auto_failover_enabled property of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        :type is_auto_failover_enabled: bool

        """
        self.swagger_types = {
            'member_id': 'str',
            'member_type': 'str',
            'is_auto_switchover_enabled': 'bool',
            'is_auto_failover_enabled': 'bool'
        }
        self.attribute_map = {
            'member_id': 'memberId',
            'member_type': 'memberType',
            'is_auto_switchover_enabled': 'isAutoSwitchoverEnabled',
            'is_auto_failover_enabled': 'isAutoFailoverEnabled'
        }
        self._member_id = None
        self._member_type = None
        self._is_auto_switchover_enabled = None
        self._is_auto_failover_enabled = None
        self._member_type = 'AUTONOMOUS_CONTAINER_DATABASE'

    @property
    def is_auto_switchover_enabled(self):
        """
        Gets the is_auto_switchover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        A flag indicating if the automatic switchover should be enabled for the Autonomous Container Database member in the Automatic DR configuration.

        Example: `false`


        :return: The is_auto_switchover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        :rtype: bool
        """
        return self._is_auto_switchover_enabled

    @is_auto_switchover_enabled.setter
    def is_auto_switchover_enabled(self, is_auto_switchover_enabled):
        """
        Sets the is_auto_switchover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        A flag indicating if the automatic switchover should be enabled for the Autonomous Container Database member in the Automatic DR configuration.

        Example: `false`


        :param is_auto_switchover_enabled: The is_auto_switchover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        :type: bool
        """
        self._is_auto_switchover_enabled = is_auto_switchover_enabled

    @property
    def is_auto_failover_enabled(self):
        """
        Gets the is_auto_failover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        A flag indicating if the automatic failover should be enabled for the Autonomous Container Database member in the Automatic DR configuration.

        Example: `false`


        :return: The is_auto_failover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        :rtype: bool
        """
        return self._is_auto_failover_enabled

    @is_auto_failover_enabled.setter
    def is_auto_failover_enabled(self, is_auto_failover_enabled):
        """
        Sets the is_auto_failover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        A flag indicating if the automatic failover should be enabled for the Autonomous Container Database member in the Automatic DR configuration.

        Example: `false`


        :param is_auto_failover_enabled: The is_auto_failover_enabled of this CreateAutomaticDrConfigurationMemberAutonomousContainerDatabaseDetails.
        :type: bool
        """
        self._is_auto_failover_enabled = is_auto_failover_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
