# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMySqlDbSystemAdminUserDetails(object):
    """
    The credentials for the HeatWave MySQL DB System administrator user, containing the username and the OCID of the Vault secret that stores the password.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMySqlDbSystemAdminUserDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param username:
            The value to assign to the username property of this CreateMySqlDbSystemAdminUserDetails.
        :type username: str

        :param password_vault_secret_id:
            The value to assign to the password_vault_secret_id property of this CreateMySqlDbSystemAdminUserDetails.
        :type password_vault_secret_id: str

        """
        self.swagger_types = {
            'username': 'str',
            'password_vault_secret_id': 'str'
        }
        self.attribute_map = {
            'username': 'username',
            'password_vault_secret_id': 'passwordVaultSecretId'
        }
        self._username = None
        self._password_vault_secret_id = None

    @property
    def username(self):
        """
        **[Required]** Gets the username of this CreateMySqlDbSystemAdminUserDetails.
        The user name for connecting to the HeatWave MySQL DB System node.

        Example: `user`


        :return: The username of this CreateMySqlDbSystemAdminUserDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this CreateMySqlDbSystemAdminUserDetails.
        The user name for connecting to the HeatWave MySQL DB System node.

        Example: `user`


        :param username: The username of this CreateMySqlDbSystemAdminUserDetails.
        :type: str
        """
        self._username = username

    @property
    def password_vault_secret_id(self):
        """
        **[Required]** Gets the password_vault_secret_id of this CreateMySqlDbSystemAdminUserDetails.
        The OCID of the vault secret where the HeatWave MySQL DB System password is stored.

        Example: `ocid1.vaultsecret.oc1..uniqueID`


        :return: The password_vault_secret_id of this CreateMySqlDbSystemAdminUserDetails.
        :rtype: str
        """
        return self._password_vault_secret_id

    @password_vault_secret_id.setter
    def password_vault_secret_id(self, password_vault_secret_id):
        """
        Sets the password_vault_secret_id of this CreateMySqlDbSystemAdminUserDetails.
        The OCID of the vault secret where the HeatWave MySQL DB System password is stored.

        Example: `ocid1.vaultsecret.oc1..uniqueID`


        :param password_vault_secret_id: The password_vault_secret_id of this CreateMySqlDbSystemAdminUserDetails.
        :type: str
        """
        self._password_vault_secret_id = password_vault_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
