# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101

from .create_distributed_autonomous_database_catalog_details import CreateDistributedAutonomousDatabaseCatalogDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails(CreateDistributedAutonomousDatabaseCatalogDetails):
    """
    Globally distributed autonomous database catalog based on Dedicated infrastructure.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.distributed_database.models.CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.source` attribute
        of this class is ``ADB_D`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
            Allowed values for this property are: "ADB_D"
        :type source: str

        :param admin_password:
            The value to assign to the admin_password property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type admin_password: str

        :param compute_count:
            The value to assign to the compute_count property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type compute_count: float

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type data_storage_size_in_gbs: float

        :param is_auto_scaling_enabled:
            The value to assign to the is_auto_scaling_enabled property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type is_auto_scaling_enabled: bool

        :param cloud_autonomous_vm_cluster_id:
            The value to assign to the cloud_autonomous_vm_cluster_id property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type cloud_autonomous_vm_cluster_id: str

        :param peer_cloud_autonomous_vm_cluster_ids:
            The value to assign to the peer_cloud_autonomous_vm_cluster_ids property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type peer_cloud_autonomous_vm_cluster_ids: list[str]

        :param peer_details:
            The value to assign to the peer_details property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type peer_details: list[oci.distributed_database.models.CreateCatalogPeerWithDedicatedInfraDetails]

        :param vault_id:
            The value to assign to the vault_id property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type vault_id: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type kms_key_version_id: str

        """
        self.swagger_types = {
            'source': 'str',
            'admin_password': 'str',
            'compute_count': 'float',
            'data_storage_size_in_gbs': 'float',
            'is_auto_scaling_enabled': 'bool',
            'cloud_autonomous_vm_cluster_id': 'str',
            'peer_cloud_autonomous_vm_cluster_ids': 'list[str]',
            'peer_details': 'list[CreateCatalogPeerWithDedicatedInfraDetails]',
            'vault_id': 'str',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str'
        }
        self.attribute_map = {
            'source': 'source',
            'admin_password': 'adminPassword',
            'compute_count': 'computeCount',
            'data_storage_size_in_gbs': 'dataStorageSizeInGbs',
            'is_auto_scaling_enabled': 'isAutoScalingEnabled',
            'cloud_autonomous_vm_cluster_id': 'cloudAutonomousVmClusterId',
            'peer_cloud_autonomous_vm_cluster_ids': 'peerCloudAutonomousVmClusterIds',
            'peer_details': 'peerDetails',
            'vault_id': 'vaultId',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId'
        }
        self._source = None
        self._admin_password = None
        self._compute_count = None
        self._data_storage_size_in_gbs = None
        self._is_auto_scaling_enabled = None
        self._cloud_autonomous_vm_cluster_id = None
        self._peer_cloud_autonomous_vm_cluster_ids = None
        self._peer_details = None
        self._vault_id = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._source = 'ADB_D'

    @property
    def admin_password(self):
        """
        **[Required]** Gets the admin_password of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        Admin password for catalog database.


        :return: The admin_password of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        Admin password for catalog database.


        :param admin_password: The admin_password of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def compute_count(self):
        """
        **[Required]** Gets the compute_count of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The compute count for the catalog database. It has to be in multiples of 2.


        :return: The compute_count of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: float
        """
        return self._compute_count

    @compute_count.setter
    def compute_count(self, compute_count):
        """
        Sets the compute_count of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The compute count for the catalog database. It has to be in multiples of 2.


        :param compute_count: The compute_count of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: float
        """
        self._compute_count = compute_count

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The data disk group size to be allocated in GBs for the catalog database.


        :return: The data_storage_size_in_gbs of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: float
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The data disk group size to be allocated in GBs for the catalog database.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: float
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def is_auto_scaling_enabled(self):
        """
        **[Required]** Gets the is_auto_scaling_enabled of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        Determines the auto-scaling mode for the catalog database.


        :return: The is_auto_scaling_enabled of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: bool
        """
        return self._is_auto_scaling_enabled

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, is_auto_scaling_enabled):
        """
        Sets the is_auto_scaling_enabled of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        Determines the auto-scaling mode for the catalog database.


        :param is_auto_scaling_enabled: The is_auto_scaling_enabled of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: bool
        """
        self._is_auto_scaling_enabled = is_auto_scaling_enabled

    @property
    def cloud_autonomous_vm_cluster_id(self):
        """
        **[Required]** Gets the cloud_autonomous_vm_cluster_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The `OCID`__ of the cloud Autonomous VM Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cloud_autonomous_vm_cluster_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: str
        """
        return self._cloud_autonomous_vm_cluster_id

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, cloud_autonomous_vm_cluster_id):
        """
        Sets the cloud_autonomous_vm_cluster_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The `OCID`__ of the cloud Autonomous VM Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cloud_autonomous_vm_cluster_id: The cloud_autonomous_vm_cluster_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: str
        """
        self._cloud_autonomous_vm_cluster_id = cloud_autonomous_vm_cluster_id

    @property
    def peer_cloud_autonomous_vm_cluster_ids(self):
        """
        Gets the peer_cloud_autonomous_vm_cluster_ids of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        This field is deprecated. This should not be used while creation of new distributed autonomous database. To set the peers
        on catalog of distributed autonomous database please use peerDetails.


        :return: The peer_cloud_autonomous_vm_cluster_ids of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: list[str]
        """
        return self._peer_cloud_autonomous_vm_cluster_ids

    @peer_cloud_autonomous_vm_cluster_ids.setter
    def peer_cloud_autonomous_vm_cluster_ids(self, peer_cloud_autonomous_vm_cluster_ids):
        """
        Sets the peer_cloud_autonomous_vm_cluster_ids of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        This field is deprecated. This should not be used while creation of new distributed autonomous database. To set the peers
        on catalog of distributed autonomous database please use peerDetails.


        :param peer_cloud_autonomous_vm_cluster_ids: The peer_cloud_autonomous_vm_cluster_ids of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: list[str]
        """
        self._peer_cloud_autonomous_vm_cluster_ids = peer_cloud_autonomous_vm_cluster_ids

    @property
    def peer_details(self):
        """
        Gets the peer_details of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The details required for creation of the peer for the autonomous dedicated infrastructure based catalog.


        :return: The peer_details of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: list[oci.distributed_database.models.CreateCatalogPeerWithDedicatedInfraDetails]
        """
        return self._peer_details

    @peer_details.setter
    def peer_details(self, peer_details):
        """
        Sets the peer_details of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The details required for creation of the peer for the autonomous dedicated infrastructure based catalog.


        :param peer_details: The peer_details of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: list[oci.distributed_database.models.CreateCatalogPeerWithDedicatedInfraDetails]
        """
        self._peer_details = peer_details

    @property
    def vault_id(self):
        """
        Gets the vault_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :return: The vault_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :param vault_id: The vault_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :return: The kms_key_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :param kms_key_id: The kms_key_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def kms_key_version_id(self):
        """
        Gets the kms_key_version_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :return: The kms_key_version_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :rtype: str
        """
        return self._kms_key_version_id

    @kms_key_version_id.setter
    def kms_key_version_id(self, kms_key_version_id):
        """
        Sets the kms_key_version_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :param kms_key_version_id: The kms_key_version_id of this CreateDistributedAutonomousDatabaseCatalogWithDedicatedInfraDetails.
        :type: str
        """
        self._kms_key_version_id = kms_key_version_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
