# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180115


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResolverRuleDetails(object):
    """
    A rule for a resolver. Specifying both qnameCoverConditions and clientAddressConditions is not allowed.

    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
    """

    #: A constant which can be used with the action property of a ResolverRuleDetails.
    #: This constant has a value of "FORWARD"
    ACTION_FORWARD = "FORWARD"

    def __init__(self, **kwargs):
        """
        Initializes a new ResolverRuleDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.dns.models.ResolverForwardRuleDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param client_address_conditions:
            The value to assign to the client_address_conditions property of this ResolverRuleDetails.
        :type client_address_conditions: list[str]

        :param qname_cover_conditions:
            The value to assign to the qname_cover_conditions property of this ResolverRuleDetails.
        :type qname_cover_conditions: list[str]

        :param action:
            The value to assign to the action property of this ResolverRuleDetails.
            Allowed values for this property are: "FORWARD"
        :type action: str

        """
        self.swagger_types = {
            'client_address_conditions': 'list[str]',
            'qname_cover_conditions': 'list[str]',
            'action': 'str'
        }
        self.attribute_map = {
            'client_address_conditions': 'clientAddressConditions',
            'qname_cover_conditions': 'qnameCoverConditions',
            'action': 'action'
        }
        self._client_address_conditions = None
        self._qname_cover_conditions = None
        self._action = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['action']

        if type == 'FORWARD':
            return 'ResolverForwardRuleDetails'
        else:
            return 'ResolverRuleDetails'

    @property
    def client_address_conditions(self):
        """
        Gets the client_address_conditions of this ResolverRuleDetails.
        A list of CIDR blocks. In order for the rule action to apply, the query must come from a client within one of
        the CIDR blocks.


        :return: The client_address_conditions of this ResolverRuleDetails.
        :rtype: list[str]
        """
        return self._client_address_conditions

    @client_address_conditions.setter
    def client_address_conditions(self, client_address_conditions):
        """
        Sets the client_address_conditions of this ResolverRuleDetails.
        A list of CIDR blocks. In order for the rule action to apply, the query must come from a client within one of
        the CIDR blocks.


        :param client_address_conditions: The client_address_conditions of this ResolverRuleDetails.
        :type: list[str]
        """
        self._client_address_conditions = client_address_conditions

    @property
    def qname_cover_conditions(self):
        """
        Gets the qname_cover_conditions of this ResolverRuleDetails.
        A list of domain names. In order for the rule action to apply, the query must either match or be a subdomain
        of one of the listed domains.


        :return: The qname_cover_conditions of this ResolverRuleDetails.
        :rtype: list[str]
        """
        return self._qname_cover_conditions

    @qname_cover_conditions.setter
    def qname_cover_conditions(self, qname_cover_conditions):
        """
        Sets the qname_cover_conditions of this ResolverRuleDetails.
        A list of domain names. In order for the rule action to apply, the query must either match or be a subdomain
        of one of the listed domains.


        :param qname_cover_conditions: The qname_cover_conditions of this ResolverRuleDetails.
        :type: list[str]
        """
        self._qname_cover_conditions = qname_cover_conditions

    @property
    def action(self):
        """
        **[Required]** Gets the action of this ResolverRuleDetails.
        The action determines the behavior of the rule. If a query matches a supplied condition, the action will
        apply. If there are no conditions on the rule, all queries are subject to the specified action.
        * `FORWARD` - Matching requests will be forwarded from the source interface to the destination address.

        Allowed values for this property are: "FORWARD"


        :return: The action of this ResolverRuleDetails.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this ResolverRuleDetails.
        The action determines the behavior of the rule. If a query matches a supplied condition, the action will
        apply. If there are no conditions on the rule, all queries are subject to the specified action.
        * `FORWARD` - Matching requests will be forwarded from the source interface to the destination address.


        :param action: The action of this ResolverRuleDetails.
        :type: str
        """
        allowed_values = ["FORWARD"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
