# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170907


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RemoveLockDetails(object):
    """
    Request payload to remove the resource lock.
    """

    #: A constant which can be used with the type property of a RemoveLockDetails.
    #: This constant has a value of "FULL"
    TYPE_FULL = "FULL"

    #: A constant which can be used with the type property of a RemoveLockDetails.
    #: This constant has a value of "DELETE"
    TYPE_DELETE = "DELETE"

    def __init__(self, **kwargs):
        """
        Initializes a new RemoveLockDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this RemoveLockDetails.
            Allowed values for this property are: "FULL", "DELETE"
        :type type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RemoveLockDetails.
        :type compartment_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'compartment_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'compartment_id': 'compartmentId'
        }
        self._type = None
        self._compartment_id = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this RemoveLockDetails.
        Lock type.

        Allowed values for this property are: "FULL", "DELETE"


        :return: The type of this RemoveLockDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this RemoveLockDetails.
        Lock type.


        :param type: The type of this RemoveLockDetails.
        :type: str
        """
        allowed_values = ["FULL", "DELETE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this RemoveLockDetails.
        The lock compartment ID.


        :return: The compartment_id of this RemoveLockDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RemoveLockDetails.
        The lock compartment ID.


        :param compartment_id: The compartment_id of this RemoveLockDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
