# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AssociatedFleetCredentialDetails(object):
    """
    The information about associated FleetCredential.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AssociatedFleetCredentialDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this AssociatedFleetCredentialDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AssociatedFleetCredentialDetails.
        :type compartment_id: str

        :param entity_specifics:
            The value to assign to the entity_specifics property of this AssociatedFleetCredentialDetails.
        :type entity_specifics: oci.fleet_apps_management.models.CredentialEntitySpecificDetails

        :param user:
            The value to assign to the user property of this AssociatedFleetCredentialDetails.
        :type user: oci.fleet_apps_management.models.CredentialDetails

        :param password:
            The value to assign to the password property of this AssociatedFleetCredentialDetails.
        :type password: oci.fleet_apps_management.models.CredentialDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'entity_specifics': 'CredentialEntitySpecificDetails',
            'user': 'CredentialDetails',
            'password': 'CredentialDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'entity_specifics': 'entitySpecifics',
            'user': 'user',
            'password': 'password'
        }
        self._display_name = None
        self._compartment_id = None
        self._entity_specifics = None
        self._user = None
        self._password = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AssociatedFleetCredentialDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this AssociatedFleetCredentialDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AssociatedFleetCredentialDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this AssociatedFleetCredentialDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AssociatedFleetCredentialDetails.
        Compartment OCID


        :return: The compartment_id of this AssociatedFleetCredentialDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AssociatedFleetCredentialDetails.
        Compartment OCID


        :param compartment_id: The compartment_id of this AssociatedFleetCredentialDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def entity_specifics(self):
        """
        **[Required]** Gets the entity_specifics of this AssociatedFleetCredentialDetails.

        :return: The entity_specifics of this AssociatedFleetCredentialDetails.
        :rtype: oci.fleet_apps_management.models.CredentialEntitySpecificDetails
        """
        return self._entity_specifics

    @entity_specifics.setter
    def entity_specifics(self, entity_specifics):
        """
        Sets the entity_specifics of this AssociatedFleetCredentialDetails.

        :param entity_specifics: The entity_specifics of this AssociatedFleetCredentialDetails.
        :type: oci.fleet_apps_management.models.CredentialEntitySpecificDetails
        """
        self._entity_specifics = entity_specifics

    @property
    def user(self):
        """
        **[Required]** Gets the user of this AssociatedFleetCredentialDetails.

        :return: The user of this AssociatedFleetCredentialDetails.
        :rtype: oci.fleet_apps_management.models.CredentialDetails
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this AssociatedFleetCredentialDetails.

        :param user: The user of this AssociatedFleetCredentialDetails.
        :type: oci.fleet_apps_management.models.CredentialDetails
        """
        self._user = user

    @property
    def password(self):
        """
        **[Required]** Gets the password of this AssociatedFleetCredentialDetails.

        :return: The password of this AssociatedFleetCredentialDetails.
        :rtype: oci.fleet_apps_management.models.CredentialDetails
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this AssociatedFleetCredentialDetails.

        :param password: The password of this AssociatedFleetCredentialDetails.
        :type: oci.fleet_apps_management.models.CredentialDetails
        """
        self._password = password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
