# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Choice(object):
    """
    choice.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Choice object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param required_values:
            The value to assign to the required_values property of this Choice.
        :type required_values: list[oci.fleet_apps_management.models.RunbookImportDependencyFinderRequiredValue]

        """
        self.swagger_types = {
            'required_values': 'list[RunbookImportDependencyFinderRequiredValue]'
        }
        self.attribute_map = {
            'required_values': 'requiredValues'
        }
        self._required_values = None

    @property
    def required_values(self):
        """
        **[Required]** Gets the required_values of this Choice.
        List of required values.


        :return: The required_values of this Choice.
        :rtype: list[oci.fleet_apps_management.models.RunbookImportDependencyFinderRequiredValue]
        """
        return self._required_values

    @required_values.setter
    def required_values(self, required_values):
        """
        Sets the required_values of this Choice.
        List of required values.


        :param required_values: The required_values of this Choice.
        :type: list[oci.fleet_apps_management.models.RunbookImportDependencyFinderRequiredValue]
        """
        self._required_values = required_values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
