# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComponentProperties(object):
    """
    The properties of the component.
    """

    #: A constant which can be used with the action_on_failure property of a ComponentProperties.
    #: This constant has a value of "ABORT"
    ACTION_ON_FAILURE_ABORT = "ABORT"

    #: A constant which can be used with the action_on_failure property of a ComponentProperties.
    #: This constant has a value of "CONTINUE"
    ACTION_ON_FAILURE_CONTINUE = "CONTINUE"

    #: A constant which can be used with the action_on_failure property of a ComponentProperties.
    #: This constant has a value of "ROLLBACK"
    ACTION_ON_FAILURE_ROLLBACK = "ROLLBACK"

    def __init__(self, **kwargs):
        """
        Initializes a new ComponentProperties object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param run_on:
            The value to assign to the run_on property of this ComponentProperties.
        :type run_on: oci.fleet_apps_management.models.RunOnDetails

        :param pre_condition:
            The value to assign to the pre_condition property of this ComponentProperties.
        :type pre_condition: str

        :param action_on_failure:
            The value to assign to the action_on_failure property of this ComponentProperties.
            Allowed values for this property are: "ABORT", "CONTINUE", "ROLLBACK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type action_on_failure: str

        :param pause_details:
            The value to assign to the pause_details property of this ComponentProperties.
        :type pause_details: oci.fleet_apps_management.models.PauseDetails

        :param notification_preferences:
            The value to assign to the notification_preferences property of this ComponentProperties.
        :type notification_preferences: oci.fleet_apps_management.models.TaskNotificationPreferences

        """
        self.swagger_types = {
            'run_on': 'RunOnDetails',
            'pre_condition': 'str',
            'action_on_failure': 'str',
            'pause_details': 'PauseDetails',
            'notification_preferences': 'TaskNotificationPreferences'
        }
        self.attribute_map = {
            'run_on': 'runOn',
            'pre_condition': 'preCondition',
            'action_on_failure': 'actionOnFailure',
            'pause_details': 'pauseDetails',
            'notification_preferences': 'notificationPreferences'
        }
        self._run_on = None
        self._pre_condition = None
        self._action_on_failure = None
        self._pause_details = None
        self._notification_preferences = None

    @property
    def run_on(self):
        """
        Gets the run_on of this ComponentProperties.

        :return: The run_on of this ComponentProperties.
        :rtype: oci.fleet_apps_management.models.RunOnDetails
        """
        return self._run_on

    @run_on.setter
    def run_on(self, run_on):
        """
        Sets the run_on of this ComponentProperties.

        :param run_on: The run_on of this ComponentProperties.
        :type: oci.fleet_apps_management.models.RunOnDetails
        """
        self._run_on = run_on

    @property
    def pre_condition(self):
        """
        Gets the pre_condition of this ComponentProperties.
        Build control flow conditions that determine the relevance of the task execution.


        :return: The pre_condition of this ComponentProperties.
        :rtype: str
        """
        return self._pre_condition

    @pre_condition.setter
    def pre_condition(self, pre_condition):
        """
        Sets the pre_condition of this ComponentProperties.
        Build control flow conditions that determine the relevance of the task execution.


        :param pre_condition: The pre_condition of this ComponentProperties.
        :type: str
        """
        self._pre_condition = pre_condition

    @property
    def action_on_failure(self):
        """
        **[Required]** Gets the action_on_failure of this ComponentProperties.
        The action to be taken in case of a failure.

        Allowed values for this property are: "ABORT", "CONTINUE", "ROLLBACK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The action_on_failure of this ComponentProperties.
        :rtype: str
        """
        return self._action_on_failure

    @action_on_failure.setter
    def action_on_failure(self, action_on_failure):
        """
        Sets the action_on_failure of this ComponentProperties.
        The action to be taken in case of a failure.


        :param action_on_failure: The action_on_failure of this ComponentProperties.
        :type: str
        """
        allowed_values = ["ABORT", "CONTINUE", "ROLLBACK"]
        if not value_allowed_none_or_none_sentinel(action_on_failure, allowed_values):
            action_on_failure = 'UNKNOWN_ENUM_VALUE'
        self._action_on_failure = action_on_failure

    @property
    def pause_details(self):
        """
        Gets the pause_details of this ComponentProperties.

        :return: The pause_details of this ComponentProperties.
        :rtype: oci.fleet_apps_management.models.PauseDetails
        """
        return self._pause_details

    @pause_details.setter
    def pause_details(self, pause_details):
        """
        Sets the pause_details of this ComponentProperties.

        :param pause_details: The pause_details of this ComponentProperties.
        :type: oci.fleet_apps_management.models.PauseDetails
        """
        self._pause_details = pause_details

    @property
    def notification_preferences(self):
        """
        Gets the notification_preferences of this ComponentProperties.

        :return: The notification_preferences of this ComponentProperties.
        :rtype: oci.fleet_apps_management.models.TaskNotificationPreferences
        """
        return self._notification_preferences

    @notification_preferences.setter
    def notification_preferences(self, notification_preferences):
        """
        Sets the notification_preferences of this ComponentProperties.

        :param notification_preferences: The notification_preferences of this ComponentProperties.
        :type: oci.fleet_apps_management.models.TaskNotificationPreferences
        """
        self._notification_preferences = notification_preferences

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
