# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataBaseVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataBaseVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_home_id:
            The value to assign to the db_home_id property of this DataBaseVariableDependsOn.
        :type db_home_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DataBaseVariableDependsOn.
        :type compartment_id: str

        """
        self.swagger_types = {
            'db_home_id': 'str',
            'compartment_id': 'str'
        }
        self.attribute_map = {
            'db_home_id': 'dbHomeId',
            'compartment_id': 'compartmentId'
        }
        self._db_home_id = None
        self._compartment_id = None

    @property
    def db_home_id(self):
        """
        **[Required]** Gets the db_home_id of this DataBaseVariableDependsOn.
        OCID of the DB home.


        :return: The db_home_id of this DataBaseVariableDependsOn.
        :rtype: str
        """
        return self._db_home_id

    @db_home_id.setter
    def db_home_id(self, db_home_id):
        """
        Sets the db_home_id of this DataBaseVariableDependsOn.
        OCID of the DB home.


        :param db_home_id: The db_home_id of this DataBaseVariableDependsOn.
        :type: str
        """
        self._db_home_id = db_home_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DataBaseVariableDependsOn.
        OCID of the compartment.


        :return: The compartment_id of this DataBaseVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DataBaseVariableDependsOn.
        OCID of the compartment.


        :param compartment_id: The compartment_id of this DataBaseVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
