# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Filter(object):
    """
    An array of Managed Entity objects
    """

    #: A constant which can be used with the filter_type property of a Filter.
    #: This constant has a value of "SINGLE_VALUE"
    FILTER_TYPE_SINGLE_VALUE = "SINGLE_VALUE"

    #: A constant which can be used with the filter_type property of a Filter.
    #: This constant has a value of "MULTI_VALUE"
    FILTER_TYPE_MULTI_VALUE = "MULTI_VALUE"

    def __init__(self, **kwargs):
        """
        Initializes a new Filter object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.MultiValueFilter`
        * :class:`~oci.fleet_apps_management.models.SingleValueFilter`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param field_name:
            The value to assign to the field_name property of this Filter.
        :type field_name: str

        :param filter_type:
            The value to assign to the filter_type property of this Filter.
            Allowed values for this property are: "SINGLE_VALUE", "MULTI_VALUE"
        :type filter_type: str

        """
        self.swagger_types = {
            'field_name': 'str',
            'filter_type': 'str'
        }
        self.attribute_map = {
            'field_name': 'fieldName',
            'filter_type': 'filterType'
        }
        self._field_name = None
        self._filter_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['filterType']

        if type == 'MULTI_VALUE':
            return 'MultiValueFilter'

        if type == 'SINGLE_VALUE':
            return 'SingleValueFilter'
        else:
            return 'Filter'

    @property
    def field_name(self):
        """
        **[Required]** Gets the field_name of this Filter.
        Name of report.


        :return: The field_name of this Filter.
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """
        Sets the field_name of this Filter.
        Name of report.


        :param field_name: The field_name of this Filter.
        :type: str
        """
        self._field_name = field_name

    @property
    def filter_type(self):
        """
        **[Required]** Gets the filter_type of this Filter.
        Content Source type details.

        Allowed values for this property are: "SINGLE_VALUE", "MULTI_VALUE"


        :return: The filter_type of this Filter.
        :rtype: str
        """
        return self._filter_type

    @filter_type.setter
    def filter_type(self, filter_type):
        """
        Sets the filter_type of this Filter.
        Content Source type details.


        :param filter_type: The filter_type of this Filter.
        :type: str
        """
        allowed_values = ["SINGLE_VALUE", "MULTI_VALUE"]
        if not value_allowed_none_or_none_sentinel(filter_type, allowed_values):
            raise ValueError(
                f"Invalid value for `filter_type`, must be None or one of {allowed_values}"
            )
        self._filter_type = filter_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
