# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetProductSummary(object):
    """
    Summary of a product associated with a Fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FleetProductSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this FleetProductSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this FleetProductSummary.
        :type display_name: str

        :param target_count:
            The value to assign to the target_count property of this FleetProductSummary.
        :type target_count: int

        :param resource:
            The value to assign to the resource property of this FleetProductSummary.
        :type resource: oci.fleet_apps_management.models.TargetResource

        :param system_tags:
            The value to assign to the system_tags property of this FleetProductSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'target_count': 'int',
            'resource': 'TargetResource',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'target_count': 'targetCount',
            'resource': 'resource',
            'system_tags': 'systemTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._target_count = None
        self._resource = None
        self._system_tags = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this FleetProductSummary.
        Root Compartment Id.


        :return: The compartment_id of this FleetProductSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FleetProductSummary.
        Root Compartment Id.


        :param compartment_id: The compartment_id of this FleetProductSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FleetProductSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this FleetProductSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FleetProductSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this FleetProductSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def target_count(self):
        """
        Gets the target_count of this FleetProductSummary.
        Count of the targets associated with the Product.


        :return: The target_count of this FleetProductSummary.
        :rtype: int
        """
        return self._target_count

    @target_count.setter
    def target_count(self, target_count):
        """
        Sets the target_count of this FleetProductSummary.
        Count of the targets associated with the Product.


        :param target_count: The target_count of this FleetProductSummary.
        :type: int
        """
        self._target_count = target_count

    @property
    def resource(self):
        """
        **[Required]** Gets the resource of this FleetProductSummary.

        :return: The resource of this FleetProductSummary.
        :rtype: oci.fleet_apps_management.models.TargetResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """
        Sets the resource of this FleetProductSummary.

        :param resource: The resource of this FleetProductSummary.
        :type: oci.fleet_apps_management.models.TargetResource
        """
        self._resource = resource

    @property
    def system_tags(self):
        """
        Gets the system_tags of this FleetProductSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this FleetProductSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this FleetProductSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this FleetProductSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
