# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KmsSecretVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KmsSecretVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this KmsSecretVariableDependsOn.
        :type compartment_id: str

        :param vault_id:
            The value to assign to the vault_id property of this KmsSecretVariableDependsOn.
        :type vault_id: str

        :param name:
            The value to assign to the name property of this KmsSecretVariableDependsOn.
        :type name: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'vault_id': 'str',
            'name': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'vault_id': 'vaultId',
            'name': 'name'
        }
        self._compartment_id = None
        self._vault_id = None
        self._name = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this KmsSecretVariableDependsOn.
        OCID of the compartment.


        :return: The compartment_id of this KmsSecretVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this KmsSecretVariableDependsOn.
        OCID of the compartment.


        :param compartment_id: The compartment_id of this KmsSecretVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vault_id(self):
        """
        Gets the vault_id of this KmsSecretVariableDependsOn.
        OCID of the Vault.


        :return: The vault_id of this KmsSecretVariableDependsOn.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this KmsSecretVariableDependsOn.
        OCID of the Vault.


        :param vault_id: The vault_id of this KmsSecretVariableDependsOn.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def name(self):
        """
        Gets the name of this KmsSecretVariableDependsOn.
        Name of the KMS secret in the vault.


        :return: The name of this KmsSecretVariableDependsOn.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this KmsSecretVariableDependsOn.
        Name of the KMS secret in the vault.


        :param name: The name of this KmsSecretVariableDependsOn.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
