# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PlatformSpecificArtifact(object):
    """
    Patch artifact metadata Details which is platform specific.
    """

    #: A constant which can be used with the os_type property of a PlatformSpecificArtifact.
    #: This constant has a value of "WINDOWS"
    OS_TYPE_WINDOWS = "WINDOWS"

    #: A constant which can be used with the os_type property of a PlatformSpecificArtifact.
    #: This constant has a value of "LINUX"
    OS_TYPE_LINUX = "LINUX"

    #: A constant which can be used with the architecture property of a PlatformSpecificArtifact.
    #: This constant has a value of "ARM_64"
    ARCHITECTURE_ARM_64 = "ARM_64"

    #: A constant which can be used with the architecture property of a PlatformSpecificArtifact.
    #: This constant has a value of "X64"
    ARCHITECTURE_X64 = "X64"

    def __init__(self, **kwargs):
        """
        Initializes a new PlatformSpecificArtifact object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content:
            The value to assign to the content property of this PlatformSpecificArtifact.
        :type content: oci.fleet_apps_management.models.PatchFileContentDetails

        :param os_type:
            The value to assign to the os_type property of this PlatformSpecificArtifact.
            Allowed values for this property are: "WINDOWS", "LINUX", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type os_type: str

        :param architecture:
            The value to assign to the architecture property of this PlatformSpecificArtifact.
            Allowed values for this property are: "ARM_64", "X64", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type architecture: str

        """
        self.swagger_types = {
            'content': 'PatchFileContentDetails',
            'os_type': 'str',
            'architecture': 'str'
        }
        self.attribute_map = {
            'content': 'content',
            'os_type': 'osType',
            'architecture': 'architecture'
        }
        self._content = None
        self._os_type = None
        self._architecture = None

    @property
    def content(self):
        """
        **[Required]** Gets the content of this PlatformSpecificArtifact.

        :return: The content of this PlatformSpecificArtifact.
        :rtype: oci.fleet_apps_management.models.PatchFileContentDetails
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this PlatformSpecificArtifact.

        :param content: The content of this PlatformSpecificArtifact.
        :type: oci.fleet_apps_management.models.PatchFileContentDetails
        """
        self._content = content

    @property
    def os_type(self):
        """
        **[Required]** Gets the os_type of this PlatformSpecificArtifact.
        The OS type the patch is applicable for.

        Allowed values for this property are: "WINDOWS", "LINUX", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The os_type of this PlatformSpecificArtifact.
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """
        Sets the os_type of this PlatformSpecificArtifact.
        The OS type the patch is applicable for.


        :param os_type: The os_type of this PlatformSpecificArtifact.
        :type: str
        """
        allowed_values = ["WINDOWS", "LINUX"]
        if not value_allowed_none_or_none_sentinel(os_type, allowed_values):
            os_type = 'UNKNOWN_ENUM_VALUE'
        self._os_type = os_type

    @property
    def architecture(self):
        """
        **[Required]** Gets the architecture of this PlatformSpecificArtifact.
        System architecture.

        Allowed values for this property are: "ARM_64", "X64", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The architecture of this PlatformSpecificArtifact.
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """
        Sets the architecture of this PlatformSpecificArtifact.
        System architecture.


        :param architecture: The architecture of this PlatformSpecificArtifact.
        :type: str
        """
        allowed_values = ["ARM_64", "X64"]
        if not value_allowed_none_or_none_sentinel(architecture, allowed_values):
            architecture = 'UNKNOWN_ENUM_VALUE'
        self._architecture = architecture

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
