# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduledFleetSummary(object):
    """
    Summary of Fleet part of the Schedule.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduledFleetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ScheduledFleetSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ScheduledFleetSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this ScheduledFleetSummary.
        :type display_name: str

        :param count_of_affected_resources:
            The value to assign to the count_of_affected_resources property of this ScheduledFleetSummary.
        :type count_of_affected_resources: int

        :param count_of_affected_targets:
            The value to assign to the count_of_affected_targets property of this ScheduledFleetSummary.
        :type count_of_affected_targets: int

        :param products:
            The value to assign to the products property of this ScheduledFleetSummary.
        :type products: list[str]

        :param system_tags:
            The value to assign to the system_tags property of this ScheduledFleetSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'count_of_affected_resources': 'int',
            'count_of_affected_targets': 'int',
            'products': 'list[str]',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'count_of_affected_resources': 'countOfAffectedResources',
            'count_of_affected_targets': 'countOfAffectedTargets',
            'products': 'products',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._count_of_affected_resources = None
        self._count_of_affected_targets = None
        self._products = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ScheduledFleetSummary.
        The OCID of the resource.


        :return: The id of this ScheduledFleetSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ScheduledFleetSummary.
        The OCID of the resource.


        :param id: The id of this ScheduledFleetSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ScheduledFleetSummary.
        The OCID of the resource.


        :return: The compartment_id of this ScheduledFleetSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ScheduledFleetSummary.
        The OCID of the resource.


        :param compartment_id: The compartment_id of this ScheduledFleetSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ScheduledFleetSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this ScheduledFleetSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ScheduledFleetSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this ScheduledFleetSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def count_of_affected_resources(self):
        """
        Gets the count_of_affected_resources of this ScheduledFleetSummary.
        Count of Resources affected by the Schedule


        :return: The count_of_affected_resources of this ScheduledFleetSummary.
        :rtype: int
        """
        return self._count_of_affected_resources

    @count_of_affected_resources.setter
    def count_of_affected_resources(self, count_of_affected_resources):
        """
        Sets the count_of_affected_resources of this ScheduledFleetSummary.
        Count of Resources affected by the Schedule


        :param count_of_affected_resources: The count_of_affected_resources of this ScheduledFleetSummary.
        :type: int
        """
        self._count_of_affected_resources = count_of_affected_resources

    @property
    def count_of_affected_targets(self):
        """
        Gets the count_of_affected_targets of this ScheduledFleetSummary.
        Count of Targets affected by the Schedule


        :return: The count_of_affected_targets of this ScheduledFleetSummary.
        :rtype: int
        """
        return self._count_of_affected_targets

    @count_of_affected_targets.setter
    def count_of_affected_targets(self, count_of_affected_targets):
        """
        Sets the count_of_affected_targets of this ScheduledFleetSummary.
        Count of Targets affected by the Schedule


        :param count_of_affected_targets: The count_of_affected_targets of this ScheduledFleetSummary.
        :type: int
        """
        self._count_of_affected_targets = count_of_affected_targets

    @property
    def products(self):
        """
        Gets the products of this ScheduledFleetSummary.
        All products part of the schedule.


        :return: The products of this ScheduledFleetSummary.
        :rtype: list[str]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this ScheduledFleetSummary.
        All products part of the schedule.


        :param products: The products of this ScheduledFleetSummary.
        :type: list[str]
        """
        self._products = products

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ScheduledFleetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ScheduledFleetSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ScheduledFleetSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ScheduledFleetSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
