# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .dedicated_ai_cluster_capacity import DedicatedAiClusterCapacity
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DedicatedAiClusterHostingCapacity(DedicatedAiClusterCapacity):
    """
    The capacity of a hosting type dedicated AI cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DedicatedAiClusterHostingCapacity object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai.models.DedicatedAiClusterHostingCapacity.capacity_type` attribute
        of this class is ``HOSTING_CAPACITY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param capacity_type:
            The value to assign to the capacity_type property of this DedicatedAiClusterHostingCapacity.
            Allowed values for this property are: "HOSTING_CAPACITY"
        :type capacity_type: str

        :param total_endpoint_capacity:
            The value to assign to the total_endpoint_capacity property of this DedicatedAiClusterHostingCapacity.
        :type total_endpoint_capacity: int

        :param used_endpoint_capacity:
            The value to assign to the used_endpoint_capacity property of this DedicatedAiClusterHostingCapacity.
        :type used_endpoint_capacity: int

        """
        self.swagger_types = {
            'capacity_type': 'str',
            'total_endpoint_capacity': 'int',
            'used_endpoint_capacity': 'int'
        }
        self.attribute_map = {
            'capacity_type': 'capacityType',
            'total_endpoint_capacity': 'totalEndpointCapacity',
            'used_endpoint_capacity': 'usedEndpointCapacity'
        }
        self._capacity_type = None
        self._total_endpoint_capacity = None
        self._used_endpoint_capacity = None
        self._capacity_type = 'HOSTING_CAPACITY'

    @property
    def total_endpoint_capacity(self):
        """
        Gets the total_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        The total number of endpoints that can be hosted on this dedicated AI cluster.


        :return: The total_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        :rtype: int
        """
        return self._total_endpoint_capacity

    @total_endpoint_capacity.setter
    def total_endpoint_capacity(self, total_endpoint_capacity):
        """
        Sets the total_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        The total number of endpoints that can be hosted on this dedicated AI cluster.


        :param total_endpoint_capacity: The total_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        :type: int
        """
        self._total_endpoint_capacity = total_endpoint_capacity

    @property
    def used_endpoint_capacity(self):
        """
        Gets the used_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        The number of endpoints hosted on this dedicated AI cluster.


        :return: The used_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        :rtype: int
        """
        return self._used_endpoint_capacity

    @used_endpoint_capacity.setter
    def used_endpoint_capacity(self, used_endpoint_capacity):
        """
        Sets the used_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        The number of endpoints hosted on this dedicated AI cluster.


        :param used_endpoint_capacity: The used_endpoint_capacity of this DedicatedAiClusterHostingCapacity.
        :type: int
        """
        self._used_endpoint_capacity = used_endpoint_capacity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
