# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SetApiKeyStateDetails(object):
    """
    The data to set the state of an API key item.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SetApiKeyStateDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key_name:
            The value to assign to the key_name property of this SetApiKeyStateDetails.
        :type key_name: str

        :param state:
            The value to assign to the state property of this SetApiKeyStateDetails.
        :type state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SetApiKeyStateDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SetApiKeyStateDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'key_name': 'str',
            'state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'key_name': 'keyName',
            'state': 'state',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._key_name = None
        self._state = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def key_name(self):
        """
        **[Required]** Gets the key_name of this SetApiKeyStateDetails.
        The key to set state.


        :return: The key_name of this SetApiKeyStateDetails.
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """
        Sets the key_name of this SetApiKeyStateDetails.
        The key to set state.


        :param key_name: The key_name of this SetApiKeyStateDetails.
        :type: str
        """
        self._key_name = key_name

    @property
    def state(self):
        """
        **[Required]** Gets the state of this SetApiKeyStateDetails.
        The target state of the API key item.


        :return: The state of this SetApiKeyStateDetails.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this SetApiKeyStateDetails.
        The target state of the API key item.


        :param state: The state of this SetApiKeyStateDetails.
        :type: str
        """
        self._state = state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this SetApiKeyStateDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this SetApiKeyStateDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this SetApiKeyStateDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this SetApiKeyStateDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this SetApiKeyStateDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this SetApiKeyStateDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this SetApiKeyStateDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this SetApiKeyStateDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
