# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HttpEndpointAuthScopeConfig(object):
    """
    Subset of AuthScopeConfig allowed for HTTP Endpoint Tool.
    """

    #: A constant which can be used with the http_endpoint_auth_scope_config_type property of a HttpEndpointAuthScopeConfig.
    #: This constant has a value of "HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG"
    HTTP_ENDPOINT_AUTH_SCOPE_CONFIG_TYPE_HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG = "HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG"

    #: A constant which can be used with the http_endpoint_auth_scope_config_type property of a HttpEndpointAuthScopeConfig.
    #: This constant has a value of "HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG"
    HTTP_ENDPOINT_AUTH_SCOPE_CONFIG_TYPE_HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG = "HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG"

    #: A constant which can be used with the http_endpoint_auth_scope_config_type property of a HttpEndpointAuthScopeConfig.
    #: This constant has a value of "HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG"
    HTTP_ENDPOINT_AUTH_SCOPE_CONFIG_TYPE_HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG = "HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG"

    #: A constant which can be used with the http_endpoint_auth_scope_config_type property of a HttpEndpointAuthScopeConfig.
    #: This constant has a value of "HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG"
    HTTP_ENDPOINT_AUTH_SCOPE_CONFIG_TYPE_HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG = "HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG"

    #: A constant which can be used with the http_endpoint_auth_scope_config_type property of a HttpEndpointAuthScopeConfig.
    #: This constant has a value of "HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG"
    HTTP_ENDPOINT_AUTH_SCOPE_CONFIG_TYPE_HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG = "HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG"

    #: A constant which can be used with the http_endpoint_auth_scope_config_type property of a HttpEndpointAuthScopeConfig.
    #: This constant has a value of "HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG"
    HTTP_ENDPOINT_AUTH_SCOPE_CONFIG_TYPE_HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG = "HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG"

    def __init__(self, **kwargs):
        """
        Initializes a new HttpEndpointAuthScopeConfig object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_agent.models.HttpEndpointBearerAuthScopeConfig`
        * :class:`~oci.generative_ai_agent.models.HttpEndpointNoAuthScopeConfig`
        * :class:`~oci.generative_ai_agent.models.HttpEndpointBasicAuthScopeConfig`
        * :class:`~oci.generative_ai_agent.models.HttpEndpointOciAuthScopeConfig`
        * :class:`~oci.generative_ai_agent.models.HttpEndpointIdcsAuthScopeConfig`
        * :class:`~oci.generative_ai_agent.models.HttpEndpointApiKeyAuthScopeConfig`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param http_endpoint_auth_scope_config_type:
            The value to assign to the http_endpoint_auth_scope_config_type property of this HttpEndpointAuthScopeConfig.
            Allowed values for this property are: "HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type http_endpoint_auth_scope_config_type: str

        """
        self.swagger_types = {
            'http_endpoint_auth_scope_config_type': 'str'
        }
        self.attribute_map = {
            'http_endpoint_auth_scope_config_type': 'httpEndpointAuthScopeConfigType'
        }
        self._http_endpoint_auth_scope_config_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['httpEndpointAuthScopeConfigType']

        if type == 'HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG':
            return 'HttpEndpointBearerAuthScopeConfig'

        if type == 'HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG':
            return 'HttpEndpointNoAuthScopeConfig'

        if type == 'HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG':
            return 'HttpEndpointBasicAuthScopeConfig'

        if type == 'HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG':
            return 'HttpEndpointOciAuthScopeConfig'

        if type == 'HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG':
            return 'HttpEndpointIdcsAuthScopeConfig'

        if type == 'HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG':
            return 'HttpEndpointApiKeyAuthScopeConfig'
        else:
            return 'HttpEndpointAuthScopeConfig'

    @property
    def http_endpoint_auth_scope_config_type(self):
        """
        **[Required]** Gets the http_endpoint_auth_scope_config_type of this HttpEndpointAuthScopeConfig.
        The type of authentication to be applied for this HTTP Endpoint.

        Allowed values for this property are: "HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The http_endpoint_auth_scope_config_type of this HttpEndpointAuthScopeConfig.
        :rtype: str
        """
        return self._http_endpoint_auth_scope_config_type

    @http_endpoint_auth_scope_config_type.setter
    def http_endpoint_auth_scope_config_type(self, http_endpoint_auth_scope_config_type):
        """
        Sets the http_endpoint_auth_scope_config_type of this HttpEndpointAuthScopeConfig.
        The type of authentication to be applied for this HTTP Endpoint.


        :param http_endpoint_auth_scope_config_type: The http_endpoint_auth_scope_config_type of this HttpEndpointAuthScopeConfig.
        :type: str
        """
        allowed_values = ["HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG"]
        if not value_allowed_none_or_none_sentinel(http_endpoint_auth_scope_config_type, allowed_values):
            http_endpoint_auth_scope_config_type = 'UNKNOWN_ENUM_VALUE'
        self._http_endpoint_auth_scope_config_type = http_endpoint_auth_scope_config_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
