# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .http_endpoint_auth_scope_config import HttpEndpointAuthScopeConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HttpEndpointIdcsAuthScopeConfig(HttpEndpointAuthScopeConfig):
    """
    Specifies authentication using Oracle Identity Cloud Service (IDCS), leveraging OAuth 2.0 Client Credentials grant type.

    - Only supported with `authScope = AGENT`.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HttpEndpointIdcsAuthScopeConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.HttpEndpointIdcsAuthScopeConfig.http_endpoint_auth_scope_config_type` attribute
        of this class is ``HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param http_endpoint_auth_scope_config_type:
            The value to assign to the http_endpoint_auth_scope_config_type property of this HttpEndpointIdcsAuthScopeConfig.
            Allowed values for this property are: "HTTP_ENDPOINT_NO_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BASIC_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_BEARER_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_API_KEY_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG", "HTTP_ENDPOINT_OCI_AUTH_SCOPE_CONFIG"
        :type http_endpoint_auth_scope_config_type: str

        :param idcs_url:
            The value to assign to the idcs_url property of this HttpEndpointIdcsAuthScopeConfig.
        :type idcs_url: str

        :param scope_url:
            The value to assign to the scope_url property of this HttpEndpointIdcsAuthScopeConfig.
        :type scope_url: str

        :param client_id:
            The value to assign to the client_id property of this HttpEndpointIdcsAuthScopeConfig.
        :type client_id: str

        :param vault_secret_id:
            The value to assign to the vault_secret_id property of this HttpEndpointIdcsAuthScopeConfig.
        :type vault_secret_id: str

        """
        self.swagger_types = {
            'http_endpoint_auth_scope_config_type': 'str',
            'idcs_url': 'str',
            'scope_url': 'str',
            'client_id': 'str',
            'vault_secret_id': 'str'
        }
        self.attribute_map = {
            'http_endpoint_auth_scope_config_type': 'httpEndpointAuthScopeConfigType',
            'idcs_url': 'idcsUrl',
            'scope_url': 'scopeUrl',
            'client_id': 'clientId',
            'vault_secret_id': 'vaultSecretId'
        }
        self._http_endpoint_auth_scope_config_type = None
        self._idcs_url = None
        self._scope_url = None
        self._client_id = None
        self._vault_secret_id = None
        self._http_endpoint_auth_scope_config_type = 'HTTP_ENDPOINT_IDCS_AUTH_SCOPE_CONFIG'

    @property
    def idcs_url(self):
        """
        **[Required]** Gets the idcs_url of this HttpEndpointIdcsAuthScopeConfig.
        IDCS OpenID discovery endpoint.


        :return: The idcs_url of this HttpEndpointIdcsAuthScopeConfig.
        :rtype: str
        """
        return self._idcs_url

    @idcs_url.setter
    def idcs_url(self, idcs_url):
        """
        Sets the idcs_url of this HttpEndpointIdcsAuthScopeConfig.
        IDCS OpenID discovery endpoint.


        :param idcs_url: The idcs_url of this HttpEndpointIdcsAuthScopeConfig.
        :type: str
        """
        self._idcs_url = idcs_url

    @property
    def scope_url(self):
        """
        **[Required]** Gets the scope_url of this HttpEndpointIdcsAuthScopeConfig.
        OAuth2 scopes for token generation.


        :return: The scope_url of this HttpEndpointIdcsAuthScopeConfig.
        :rtype: str
        """
        return self._scope_url

    @scope_url.setter
    def scope_url(self, scope_url):
        """
        Sets the scope_url of this HttpEndpointIdcsAuthScopeConfig.
        OAuth2 scopes for token generation.


        :param scope_url: The scope_url of this HttpEndpointIdcsAuthScopeConfig.
        :type: str
        """
        self._scope_url = scope_url

    @property
    def client_id(self):
        """
        **[Required]** Gets the client_id of this HttpEndpointIdcsAuthScopeConfig.
        IDCS client ID.


        :return: The client_id of this HttpEndpointIdcsAuthScopeConfig.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """
        Sets the client_id of this HttpEndpointIdcsAuthScopeConfig.
        IDCS client ID.


        :param client_id: The client_id of this HttpEndpointIdcsAuthScopeConfig.
        :type: str
        """
        self._client_id = client_id

    @property
    def vault_secret_id(self):
        """
        **[Required]** Gets the vault_secret_id of this HttpEndpointIdcsAuthScopeConfig.
        Vault secret OCID containing the client secret.


        :return: The vault_secret_id of this HttpEndpointIdcsAuthScopeConfig.
        :rtype: str
        """
        return self._vault_secret_id

    @vault_secret_id.setter
    def vault_secret_id(self, vault_secret_id):
        """
        Sets the vault_secret_id of this HttpEndpointIdcsAuthScopeConfig.
        Vault secret OCID containing the client secret.


        :param vault_secret_id: The vault_secret_id of this HttpEndpointIdcsAuthScopeConfig.
        :type: str
        """
        self._vault_secret_id = vault_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
