# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LlmConfig(object):
    """
    Configuration to Agent LLM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LlmConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param routing_llm_customization:
            The value to assign to the routing_llm_customization property of this LlmConfig.
        :type routing_llm_customization: oci.generative_ai_agent.models.LlmCustomization

        :param runtime_version:
            The value to assign to the runtime_version property of this LlmConfig.
        :type runtime_version: str

        """
        self.swagger_types = {
            'routing_llm_customization': 'LlmCustomization',
            'runtime_version': 'str'
        }
        self.attribute_map = {
            'routing_llm_customization': 'routingLlmCustomization',
            'runtime_version': 'runtimeVersion'
        }
        self._routing_llm_customization = None
        self._runtime_version = None

    @property
    def routing_llm_customization(self):
        """
        Gets the routing_llm_customization of this LlmConfig.

        :return: The routing_llm_customization of this LlmConfig.
        :rtype: oci.generative_ai_agent.models.LlmCustomization
        """
        return self._routing_llm_customization

    @routing_llm_customization.setter
    def routing_llm_customization(self, routing_llm_customization):
        """
        Sets the routing_llm_customization of this LlmConfig.

        :param routing_llm_customization: The routing_llm_customization of this LlmConfig.
        :type: oci.generative_ai_agent.models.LlmCustomization
        """
        self._routing_llm_customization = routing_llm_customization

    @property
    def runtime_version(self):
        """
        Gets the runtime_version of this LlmConfig.
        The runtimeVersion of the system prompt.


        :return: The runtime_version of this LlmConfig.
        :rtype: str
        """
        return self._runtime_version

    @runtime_version.setter
    def runtime_version(self, runtime_version):
        """
        Sets the runtime_version of this LlmConfig.
        The runtimeVersion of the system prompt.


        :param runtime_version: The runtime_version of this LlmConfig.
        :type: str
        """
        self._runtime_version = runtime_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
